<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		if( isset( $post['has_thumbnail'] ) && $post['has_thumbnail'] ) {
			$placeholder = themify_get_placeholder_image();
			if( ! is_wp_error( $placeholder ) ) {
				set_post_thumbnail( $post_id, $placeholder );
			}
		}

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $term['parent'], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_do_demo_import() {

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 24,
  'name' => 'Latest News',
  'slug' => 'latest-news',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 21,
  'name' => 'Icon Menu',
  'slug' => 'icon-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 22,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 23,
  'name' => 'Footer Support Menu',
  'slug' => 'footer-support-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 2659,
  'post_date' => '2017-03-13 10:34:16',
  'post_date_gmt' => '2017-03-13 10:34:16',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur.',
  'post_title' => 'Halo Indonesia. Waktunya Spotify!',
  'post_excerpt' => '',
  'post_name' => 'halo-indonesia-waktunya-spotify',
  'post_modified' => '2017-04-21 13:14:32',
  'post_modified_gmt' => '2017-04-21 13:14:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?p=2659',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'latest-news',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2657,
  'post_date' => '2017-03-12 15:31:40',
  'post_date_gmt' => '2017-03-12 15:31:40',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.

Et harum quidem rerum facilis est et expedita distinctio.At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Spotify now available on Amazon Echo',
  'post_excerpt' => '',
  'post_name' => 'spotify-now-available-amazon-echo',
  'post_modified' => '2017-04-21 13:41:14',
  'post_modified_gmt' => '2017-04-21 13:41:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?p=2657',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'latest-news',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2654,
  'post_date' => '2017-03-12 10:30:14',
  'post_date_gmt' => '2017-03-12 10:30:14',
  'post_content' => 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Work/Life Balance at Spotify',
  'post_excerpt' => '',
  'post_name' => 'worklife-balance-spotify',
  'post_modified' => '2017-04-21 13:09:33',
  'post_modified_gmt' => '2017-04-21 13:09:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?p=2654',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'latest-news',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2651,
  'post_date' => '2017-03-11 15:28:46',
  'post_date_gmt' => '2017-03-11 15:28:46',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet.',
  'post_title' => 'Ed Sheeran hits 500M streams',
  'post_excerpt' => '',
  'post_name' => 'ed-sheeran-hits-500m-streams',
  'post_modified' => '2017-04-21 13:26:27',
  'post_modified_gmt' => '2017-04-21 13:26:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?p=2651',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'latest-news',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2647,
  'post_date' => '2017-03-11 10:28:01',
  'post_date_gmt' => '2017-03-11 10:28:01',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_title' => 'Spotify and Chrome now play together',
  'post_excerpt' => '',
  'post_name' => 'spotify-chrome-now-play-together',
  'post_modified' => '2017-04-21 13:03:22',
  'post_modified_gmt' => '2017-04-21 13:03:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?p=2647',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'latest-news',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2640,
  'post_date' => '2017-03-10 10:25:31',
  'post_date_gmt' => '2017-03-10 10:25:31',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => '$2 Billion and Counting',
  'post_excerpt' => '',
  'post_name' => '2-billion-counting',
  'post_modified' => '2017-04-21 13:08:57',
  'post_modified_gmt' => '2017-04-21 13:08:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?p=2640',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'latest-news',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2625,
  'post_date' => '2017-03-14 10:01:58',
  'post_date_gmt' => '2017-03-14 10:01:58',
  'post_content' => 'Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Nemo enim Album',
  'post_excerpt' => '',
  'post_name' => 'nemo-enim-album',
  'post_modified' => '2017-04-21 13:31:21',
  'post_modified_gmt' => '2017-04-21 13:31:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?p=2625',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'latest-news',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2623,
  'post_date' => '2017-03-14 05:01:05',
  'post_date_gmt' => '2017-03-14 05:01:05',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Sed do eiusmod Album',
  'post_excerpt' => '',
  'post_name' => 'sed-eiusmod-album',
  'post_modified' => '2017-04-21 13:20:48',
  'post_modified_gmt' => '2017-04-21 13:20:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?p=2623',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'latest-news',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2617,
  'post_date' => '2017-03-13 16:00:17',
  'post_date_gmt' => '2017-03-13 16:00:17',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.',
  'post_title' => 'Spotify acquires Album',
  'post_excerpt' => '',
  'post_name' => 'spotify-acquires-album',
  'post_modified' => '2017-04-21 13:31:35',
  'post_modified_gmt' => '2017-04-21 13:31:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?p=2617',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'latest-news',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2702,
  'post_date' => '2017-04-21 18:33:10',
  'post_date_gmt' => '2017-04-21 18:33:10',
  'post_content' => '',
  'post_title' => 'Wishlist',
  'post_excerpt' => '',
  'post_name' => 'wishlist',
  'post_modified' => '2017-04-21 18:33:16',
  'post_modified_gmt' => '2017-04-21 18:33:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?page_id=2702',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2551,
  'post_date' => '2017-03-10 12:24:14',
  'post_date_gmt' => '2017-03-10 12:24:14',
  'post_content' => '<!--themify_builder_static--><h1>Angus Macrae New Album</h1><h5>Choose your music by genre, workout type, BPM, and more.</h5>
 
 <a href="https://themify.me/demo/themes/shoppe-music/shop/" > Shop Now </a> 
 
 <img src="https://themify.me/demo/themes/shoppe-music/files/2017/03/man-with-gitar.png" alt="man-with-gitar" srcset="https://themify.me/demo/themes/shoppe-music/files/2017/03/man-with-gitar.png 954w, https://themify.me/demo/themes/shoppe-music/files/2017/03/man-with-gitar-300x210.png 300w, https://themify.me/demo/themes/shoppe-music/files/2017/03/man-with-gitar-768x538.png 768w" sizes="(max-width: 954px) 100vw, 954px" /> 
 
 <img src="https://themify.me/demo/themes/shoppe-music/files/2017/03/record-disk.png" alt="record-disk" srcset="https://themify.me/demo/themes/shoppe-music/files/2017/03/record-disk.png 600w, https://themify.me/demo/themes/shoppe-music/files/2017/03/record-disk-300x240.png 300w, https://themify.me/demo/themes/shoppe-music/files/2017/03/record-disk-200x160.png 200w" sizes="(max-width: 600px) 100vw, 600px" /> 
 
 <h2>Out Now</h2><h5>New single From Angus Macrae</h5><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do enim ad eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut minim veniam, quis nostrud exercitation ullamco laboris.</p>
 
 <ol> <li itemprop="track" itemscope="" itemtype="http://schema.org/MusicRecording"> <a href="#" itemprop="url">Helpless</a> <audio id="audio-0-1" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/addon-audio/files/2015/06/Helpless.mp3?_=1" /><a href="https://themify.me/demo/themes/addon-audio/files/2015/06/Helpless.mp3">https://themify.me/demo/themes/addon-audio/files/2015/06/Helpless.mp3</a></audio> </li> </ol> 
 <h2>Album Review</h2>
 
 <ol> <li itemprop="track" itemscope="" itemtype="http://schema.org/MusicRecording"> <a href="#" itemprop="url">Helpless</a> <audio id="audio-0-2" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/addon-audio/files/2015/06/Helpless.mp3?_=2" /><a href="https://themify.me/demo/themes/addon-audio/files/2015/06/Helpless.mp3">https://themify.me/demo/themes/addon-audio/files/2015/06/Helpless.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="http://schema.org/MusicRecording"> <a href="#" itemprop="url">O Song</a> <audio id="audio-0-3" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/addon-audio/files/2015/06/o.mp3?_=3" /><a href="https://themify.me/demo/themes/addon-audio/files/2015/06/o.mp3">https://themify.me/demo/themes/addon-audio/files/2015/06/o.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="http://schema.org/MusicRecording"> <a href="#" itemprop="url">Mystery Night</a> <audio id="audio-0-4" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/addon-audio/files/2015/06/db-Insom-Mystery-Night.mp3?_=4" /><a href="https://themify.me/demo/themes/addon-audio/files/2015/06/db-Insom-Mystery-Night.mp3">https://themify.me/demo/themes/addon-audio/files/2015/06/db-Insom-Mystery-Night.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="http://schema.org/MusicRecording"> <a href="#" itemprop="url">Aggregate Mass</a> <audio id="audio-0-5" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/addon-audio/files/2015/06/crsh-grey_aggregate_mass.mp3?_=5" /><a href="https://themify.me/demo/themes/addon-audio/files/2015/06/crsh-grey_aggregate_mass.mp3">https://themify.me/demo/themes/addon-audio/files/2015/06/crsh-grey_aggregate_mass.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="http://schema.org/MusicRecording"> <a href="#" itemprop="url">Oniongrass</a> <audio id="audio-0-6" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/addon-audio/files/2015/06/funk-oniongrass.mp3?_=6" /><a href="https://themify.me/demo/themes/addon-audio/files/2015/06/funk-oniongrass.mp3">https://themify.me/demo/themes/addon-audio/files/2015/06/funk-oniongrass.mp3</a></audio> </li> </ol> 
 
 
 <img src="https://themify.me/demo/themes/shoppe-music/files/2017/03/man-1.jpg" alt="man-1" srcset="https://themify.me/demo/themes/shoppe-music/files/2017/03/man-1.jpg 601w, https://themify.me/demo/themes/shoppe-music/files/2017/03/man-1-300x277.jpg 300w" sizes="(max-width: 601px) 100vw, 601px" /> 
 <h2>Recent Albums</h2>
 
 <ul data-width="260" data-height="245">
 <li data-product-id="2713"> <figure ><a href="https://themify.me/demo/themes/shoppe-music/product/avenger/"><img src="https://themify.me/demo/themes/shoppe-music/files/2017/05/album-7-260x245.jpg" width="260" height="245" alt="album-7" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-music/product/avenger/"> <h3>Avenger</h3> &#36;30.90 </a> <a rel="nofollow" href="/demo/themes/shoppe-music/wp-admin/admin-ajax.php?add-to-cart=2713" data-quantity="1" data-product_id="2713" data-product_sku="">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-music/wp-admin/post.php?post=2713&#038;action=edit">Edit</a>] <a data-id="2713" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-music/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=2713"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-music/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-music/product/avenger/?post_in_lightbox=1">Quick Look</a> </li> <li data-product-id="2717"> <figure ><a href="https://themify.me/demo/themes/shoppe-music/product/odesza-in-return/"><img src="https://themify.me/demo/themes/shoppe-music/files/2017/03/album-6-260x245.jpg" width="260" height="245" alt="album-6" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-music/product/odesza-in-return/"> <h3>Odesza In Return</h3> &#36;25.50 </a> <a rel="nofollow" href="/demo/themes/shoppe-music/wp-admin/admin-ajax.php?add-to-cart=2717" data-quantity="1" data-product_id="2717" data-product_sku="">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-music/wp-admin/post.php?post=2717&#038;action=edit">Edit</a>] <a data-id="2717" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-music/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=2717"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-music/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-music/product/odesza-in-return/?post_in_lightbox=1">Quick Look</a> </li> <li data-product-id="2569"> <figure ><a href="https://themify.me/demo/themes/shoppe-music/product/black-beatles/"><img src="https://themify.me/demo/themes/shoppe-music/files/2017/03/album-1-260x245.jpg" width="260" height="245" alt="album-1" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-music/product/black-beatles/"> <h3>Black Beatles</h3> &#36;25.90 </a> <a rel="nofollow" href="/demo/themes/shoppe-music/wp-admin/admin-ajax.php?add-to-cart=2569" data-quantity="1" data-product_id="2569" data-product_sku="">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-music/wp-admin/post.php?post=2569&#038;action=edit">Edit</a>] <a data-id="2569" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-music/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=2569"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-music/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-music/product/black-beatles/?post_in_lightbox=1">Quick Look</a> </li> <li data-product-id="2568"> <figure ><a href="https://themify.me/demo/themes/shoppe-music/product/under-the-iron-sea/"><img src="https://themify.me/demo/themes/shoppe-music/files/2017/03/album-2-260x245.jpg" width="260" height="245" alt="album-2" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-music/product/under-the-iron-sea/"> <h3>Under the Iron Sea</h3> &#36;26.90 </a> <a rel="nofollow" href="/demo/themes/shoppe-music/wp-admin/admin-ajax.php?add-to-cart=2568" data-quantity="1" data-product_id="2568" data-product_sku="">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-music/wp-admin/post.php?post=2568&#038;action=edit">Edit</a>] <a data-id="2568" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-music/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=2568"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-music/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-music/product/under-the-iron-sea/?post_in_lightbox=1">Quick Look</a> </li> </ul>
 
 
 <a href="https://themify.me/demo/themes/shoppe-music/shop/" > View All </a> 
 
 <img src="https://themify.me/demo/themes/shoppe-music/files/2017/03/volumn-icon.png" alt="volumn-icon" /> 
 <h2>The Audio module is simple<br />and easy to set-up</h2><h5>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec sit amet mi mi. Nullam id mi ut.</h5>
 
 <a href="https://themify.me/themes/shoppe" > Buy album now </a> 
 
 <img src="https://themify.me/demo/themes/shoppe-music/files/2017/05/itune-button.png" alt="itune-button" /><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2017-12-27 17:55:56',
  'post_modified_gmt' => '2017-12-27 17:55:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?page_id=2551',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_wrap' => 'transparent',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Angus Macrae New Album<\\\\/h1><h5>Choose your music by genre, workout type, BPM, and more.<\\\\/h5>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"font_color\\":\\"ffffff_1.00\\",\\"column_count\\":\\"1\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_h1\\":\\"71\\",\\"line_height_h1\\":\\"1\\",\\"line_height_h1_unit\\":\\"em\\",\\"h1_margin_bottom\\":\\"25\\",\\"font_size_h5\\":\\"18\\",\\"h5_margin_bottom\\":\\"35\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h1\\":\\"50\\",\\"h1_margin_bottom\\":\\"20\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h1\\":\\"45\\",\\"h1_margin_bottom\\":\\"15\\"},\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h1\\":\\"41\\"},\\"cid\\":\\"c22\\"}},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"xlarge\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Shop Now\\",\\"link\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/shop\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\"}],\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"em\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"link_checkbox_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"em\\",\\"margin_bottom_unit\\":\\"em\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\"},\\"cid\\":\\"c26\\"}}],\\"grid_width\\":\\"38.2556\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"0\\",\\"padding_left_unit\\":\\"%\\",\\"breakpoint_tablet_landscape\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_left_unit\\":\\"%\\"},\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_left_unit\\":\\"%\\"},\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_left\\":\\"0\\"}}},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/man-with-gitar.png\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"-4.3\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"-1\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"-4.2\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_left\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"-4\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"cid\\":\\"c34\\"}}],\\"grid_width\\":\\"61.7444\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"custom_css_column\\":\\"banner-img\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\"}}}],\\"column_alignment\\":\\"col_align_bottom\\",\\"gutter\\":\\"gutter-none\\",\\"col_mobile\\":\\"mobile-full\\"}]}],\\"col_tablet\\":\\"tablet-full\\",\\"col_mobile\\":\\"mobile-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"best-fit\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/hero-banner-bg.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"0\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"0\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/record-disk.png\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"cid\\":\\"c53\\"}},{\\"mod_name\\":\\"layout-part\\"}]},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Out Now<\\\\/h2><h5>New single From Angus Macrae<\\\\/h5><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do enim ad eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut minim veniam, quis nostrud exercitation ullamco laboris.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"font_color\\":\\"808080_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_color_h2\\":\\"434789_1.00\\",\\"font_size_h2\\":\\"72\\",\\"h2_margin_bottom\\":\\"0\\",\\"font_color_h5\\":\\"333333_1.00\\",\\"font_size_h5\\":\\"18\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"50\\"},\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"42\\"},\\"cid\\":\\"c65\\"}},{\\"mod_name\\":\\"audio\\",\\"mod_settings\\":{\\"background_color\\":\\"ffffff\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_tablet\\":{\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"15\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"15\\",\\"margin_bottom\\":\\"20\\"},\\"breakpoint_mobile\\":{\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"10\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"15\\"},\\"music_playlist\\":[{\\"audio_name\\":\\"Helpless\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/Helpless.mp3\\"}],\\"hide_download_audio\\":\\"yes\\",\\"add_css_audio\\":\\"out-now-audio\\",\\"animation_effect\\":\\"fadeInRight\\",\\"cid\\":\\"c69\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_left\\":\\"7\\",\\"padding_left_unit\\":\\"%\\",\\"breakpoint_tablet_landscape\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"20\\"},\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"0\\",\\"padding_right\\":\\"0\\",\\"padding_bottom\\":\\"0\\",\\"padding_left\\":\\"0\\"},\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"0\\",\\"padding_right\\":\\"0\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"0\\"}}}],\\"column_alignment\\":\\"col_align_middle\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Album Review<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"padding_left\\":\\"10\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_color_h2\\":\\"434789_1.00\\",\\"font_size_h2\\":\\"36\\",\\"h2_margin_top\\":\\"20\\",\\"h2_margin_bottom\\":\\"10\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"padding_top\\":\\"0\\",\\"padding_right\\":\\"0\\",\\"padding_bottom\\":\\"0\\",\\"padding_left\\":\\"5\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"34\\"},\\"cid\\":\\"c81\\"}},{\\"mod_name\\":\\"audio\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"music_playlist\\":[{\\"audio_name\\":\\"Helpless\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/Helpless.mp3\\"},{\\"audio_name\\":\\"O Song\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/o.mp3\\"},{\\"audio_name\\":\\"Mystery Night\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/db-Insom-Mystery-Night.mp3\\"},{\\"audio_name\\":\\"Aggregate Mass\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/crsh-grey_aggregate_mass.mp3\\"},{\\"audio_name\\":\\"Oniongrass\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/funk-oniongrass.mp3\\"}],\\"hide_download_audio\\":\\"yes\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"cid\\":\\"c85\\"}},{\\"mod_name\\":\\"layout-part\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"0\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"28\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"15\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"15\\"},\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"15\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"10\\"}}},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/man-1.jpg\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"cid\\":\\"c97\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"ffffff_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"custom_css_column\\":\\"shadow\\"}},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Recent Albums<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_color_h2\\":\\"434789_1.00\\",\\"font_size_h2\\":\\"50\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"39\\"},\\"cid\\":\\"c101\\"}},{\\"mod_name\\":\\"products\\",\\"mod_settings\\":{\\"query_products\\":\\"all\\",\\"category_products\\":\\"0|multiple\\",\\"hide_child_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"post_per_page_products\\":\\"4\\",\\"orderby_products\\":\\"date\\",\\"order_products\\":\\"desc\\",\\"template_products\\":\\"list\\",\\"layout_products\\":\\"grid4\\",\\"masonry_post\\":\\"no\\",\\"disable_product_slider\\":\\"enable\\",\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"description_products\\":\\"none\\",\\"hide_feat_img_products\\":\\"no\\",\\"img_width_products\\":\\"260\\",\\"img_height_products\\":\\"245\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_page_nav_products\\":\\"yes\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"xlarge\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"View All\\",\\"link\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/shop\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\"}],\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"cid\\":\\"c109\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"best-fit\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/musicbg.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"5\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom\\":\\"0\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/volumn-icon.png\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"33\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"cid\\":\\"c120\\"}},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>The Audio module is simple<br \\\\/>and easy to set-up<\\\\/h2><h5>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec sit amet mi mi. Nullam id mi ut.<\\\\/h5>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_color_h2\\":\\"ffffff_1.00\\",\\"font_size_h2\\":\\"48\\",\\"line_height_h2\\":\\"48\\",\\"font_color_h5\\":\\"ffffff_1.00\\",\\"font_size_h5\\":\\"16\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"35\\",\\"line_height_h2\\":\\"42\\"},\\"cid\\":\\"c124\\"}},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Buy album now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/shoppe\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\"}],\\"css_button\\":\\"buy-button\\",\\"animation_effect\\":\\"fadeInUp\\"}}]},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/05\\\\/itune-button.png\\",\\"param_image\\":\\"regular\\",\\"margin_top\\":\\"30\\",\\"cid\\":\\"c144\\"}}]}],\\"gutter\\":\\"gutter-narrow\\"}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"best-fit\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/background.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2580,
  'post_date' => '2017-03-10 13:10:28',
  'post_date_gmt' => '2017-03-10 13:10:28',
  'post_content' => '',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2017-03-10 13:10:28',
  'post_modified_gmt' => '2017-03-10 13:10:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/shop/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2581,
  'post_date' => '2017-03-10 13:10:28',
  'post_date_gmt' => '2017-03-10 13:10:28',
  'post_content' => '[woocommerce_cart]',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2017-03-10 13:10:28',
  'post_modified_gmt' => '2017-03-10 13:10:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2582,
  'post_date' => '2017-03-10 13:10:28',
  'post_date_gmt' => '2017-03-10 13:10:28',
  'post_content' => '[woocommerce_checkout]',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2017-03-10 13:10:28',
  'post_modified_gmt' => '2017-03-10 13:10:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2583,
  'post_date' => '2017-03-10 13:10:28',
  'post_date_gmt' => '2017-03-10 13:10:28',
  'post_content' => '[woocommerce_my_account]',
  'post_title' => 'My Account',
  'post_excerpt' => '',
  'post_name' => 'my-account',
  'post_modified' => '2017-03-10 13:10:28',
  'post_modified_gmt' => '2017-03-10 13:10:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/my-account/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2588,
  'post_date' => '2017-03-10 13:15:47',
  'post_date_gmt' => '2017-03-10 13:15:47',
  'post_content' => '',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2017-10-31 20:00:35',
  'post_modified_gmt' => '2017-10-31 20:00:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?page_id=2588',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_wrap' => 'transparent',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>About Me<\\\\/h1><h5>Hi I’m Angus Macrae talented musician &amp; producer.<\\\\/h5>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h1\\":\\"80\\",\\"line_height_h1\\":\\"1\\",\\"line_height_h1_unit\\":\\"em\\",\\"h1_margin_bottom\\":\\"5\\",\\"font_size_h5\\":\\"18\\",\\"h5_margin_bottom\\":\\"35\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h1\\":\\"67\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h1\\":\\"50\\"},\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h1\\":\\"41\\"}}},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"xlarge\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Buy my Album\\",\\"link\\":\\"#\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\"}],\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"text_decoration\\":\\"none\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"best-fit\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/about-bg-1.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"22\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"17\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Hi I’m <a href=\\\\\\\\\\\\\\"#\\\\\\\\\\\\\\">Angus Macrae<\\\\/a> Talented Musician.<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"link_color\\":\\"a97ae3_1.00\\",\\"link_color_hover\\":\\"434789_1.00\\",\\"text_decoration\\":\\"none\\",\\"column_count\\":\\"1\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_h2\\":\\"434789_1.00\\",\\"font_size_h2\\":\\"48\\",\\"line_height_h2\\":\\"60\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"35\\",\\"line_height_h2\\":\\"50\\"}}}]},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>New single From Angus Macrae<\\\\/h3><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sit amet mattis sapien. Mauris cursus tellus ut egestas maximus. Aliquam laoreet felis sed porta ultricies. Aliquam pulvinar erat ut tortor vulputate, et eleifend turpis eleifend. Nam sollicitudin bibendum tellus et consequat. Curabitur ultrices posuere bibendum. Ut a mi lorem. Nunc pulvinar ipsum vitae egestas suscipit.<\\\\/p><p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Donec elementum turpis a lacinia semper. Nulla in lectus non ante efficitur aliquet.<br \\\\/>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Donec elementum turpis a lacinia semper.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_h3\\":\\"404040_1.00\\",\\"font_size_h3\\":\\"30\\",\\"line_height_h3\\":\\"48\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"best-fit\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/04\\\\/man-with-gitar-1024x725.png\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"4524a8_0.61\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Music is My Passion<br \\\\/>&amp; Everything<\\\\/h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sit amet mattis sapien. Mauris cursus tellus ut egestas maximus. Aliquam laoreet felis sed porta ultricies. Aliquam pulvinar erat ut tortor vulputate, et eleifend turpis eleifend. Nam sollicitudin bibendum tellus et consequat.<\\\\/p><p>[themify_col grid=\\\\\\\\\\\\\\"2-1 first\\\\\\\\\\\\\\"][themify_list icon=\\\\\\\\\\\\\\"fa-check\\\\\\\\\\\\\\" icon_color=\\\\\\\\\\\\\\"#a97ae3\\\\\\\\\\\\\\"]<\\\\/p><ul><li>Nam consectetur adipiscing<\\\\/li><li>Consectetur adipisicing elit<\\\\/li><li>Nemo enim ipsam voluptatem<\\\\/li><\\\\/ul><p>[\\\\/themify_list][\\\\/themify_col][themify_col grid=\\\\\\\\\\\\\\"2-1\\\\\\\\\\\\\\"][themify_list icon=\\\\\\\\\\\\\\"fa-check\\\\\\\\\\\\\\" icon_color=\\\\\\\\\\\\\\"#a97ae3\\\\\\\\\\\\\\"]<\\\\/p><ul><li>Sed do eiusmod tempor incididunt<\\\\/li><li>Ut enim ad minima veniam<\\\\/li><li>Excepteur sint occaecat cupidatat<\\\\/li><\\\\/ul><p>[\\\\/themify_list][\\\\/themify_col]<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"48\\",\\"line_height_h2\\":\\"60\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"38\\",\\"line_height_h2\\":\\"50\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"434789_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"0\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Albums<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"20\\",\\"font_color_h2\\":\\"434789_1.00\\",\\"font_size_h2\\":\\"48\\",\\"line_height_h2\\":\\"60\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"38\\",\\"line_height_h2\\":\\"50\\"}}},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Album Review<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"padding_left\\":\\"10\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_color_h2\\":\\"434789_1.00\\",\\"font_size_h2\\":\\"36\\",\\"h2_margin_top\\":\\"20\\",\\"h2_margin_bottom\\":\\"10\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"padding_top\\":\\"0\\",\\"padding_right\\":\\"0\\",\\"padding_bottom\\":\\"0\\",\\"padding_left\\":\\"5\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h2\\":\\"34\\"}}},{\\"mod_name\\":\\"audio\\",\\"mod_settings\\":{\\"music_playlist\\":[{\\"audio_name\\":\\"I\\\\\\\\\\\'ve Not Over Yet\\",\\"audio_url\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/myuu-ItsNotOverYet.mp3\\"},{\\"audio_name\\":\\"Helpless\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/Helpless.mp3\\"},{\\"audio_name\\":\\"O Song\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/o.mp3\\"},{\\"audio_name\\":\\"Mystery Night\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/db-Insom-Mystery-Night.mp3\\"},{\\"audio_name\\":\\"Aggregate Mass\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/crsh-grey_aggregate_mass.mp3\\"},{\\"audio_name\\":\\"Oniongrass\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addon-audio\\\\/files\\\\/2015\\\\/06\\\\/funk-oniongrass.mp3\\"}],\\"hide_download_audio\\":\\"yes\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"layout-part\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"best-fit\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"0\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"28\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"15\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"15\\"},\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"15\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"10\\"}}},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/man-1.jpg\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"custom_css_column\\":\\"shadow\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"best-fit\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"products\\",\\"mod_settings\\":{\\"query_products\\":\\"all\\",\\"category_products\\":\\"0|multiple\\",\\"hide_child_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"post_per_page_products\\":\\"4\\",\\"orderby_products\\":\\"date\\",\\"order_products\\":\\"desc\\",\\"template_products\\":\\"list\\",\\"layout_products\\":\\"grid4\\",\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"description_products\\":\\"none\\",\\"hide_feat_img_products\\":\\"no\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_page_nav_products\\":\\"yes\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Buy on itunes\\",\\"link\\":\\"#\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\"}],\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_bottom_color\\":\\"dddddd_1.00\\",\\"border_bottom_width\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>From the Blog.<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_color_h2\\":\\"434789_1.00\\",\\"font_size_h2\\":\\"48\\",\\"line_height_h2\\":\\"60\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"post\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid3\\",\\"post_type_post\\":\\"post\\",\\"content_layout\\":\\"polaroid\\",\\"masonry_post\\":\\"no\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"post_per_page_post\\":\\"3\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"excerpt\\",\\"img_width_post\\":\\"361\\",\\"img_height_post\\":\\"381\\",\\"hide_post_date_post\\":\\"no\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"View All Articles\\",\\"link\\":\\"#\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\"}],\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"25\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"6\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2590,
  'post_date' => '2017-03-10 13:16:14',
  'post_date_gmt' => '2017-03-10 13:16:14',
  'post_content' => '',
  'post_title' => 'Blog',
  'post_excerpt' => '',
  'post_name' => 'blog-2',
  'post_modified' => '2017-05-09 22:12:54',
  'post_modified_gmt' => '2017-05-09 22:12:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?page_id=2590',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":{\\"1\\":{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Latest Blog<\\\\/h1>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_color_h1\\":\\"ffffff_1.00\\",\\"font_size_h1\\":\\"48\\",\\"line_height_h1\\":\\"60\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1\\":\\"38\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1\\":\\"50\\",\\"line_height_h1_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"h1_margin_bottom_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"h2_margin_top_unit\\":\\"px\\",\\"h2_margin_bottom_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"h5_margin_top_unit\\":\\"px\\",\\"h5_margin_bottom_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"h6_margin_top_unit\\":\\"px\\",\\"h6_margin_bottom_unit\\":\\"px\\"}}}},\\"styling\\":[]}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"best-fit\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/blog.jpg\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"6950d1_0.59\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_mobile\\":\\"show\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":{\\"1\\":{\\"mod_name\\":\\"post\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid3\\",\\"post_type_post\\":\\"post\\",\\"content_layout\\":\\"polaroid\\",\\"masonry_post\\":\\"no\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"post_per_page_post\\":\\"9\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"excerpt\\",\\"img_width_post\\":\\"361\\",\\"img_height_post\\":\\"381\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}},\\"styling\\":[]}],\\"column_alignment\\":\\"\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/blog-background.png\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2592,
  'post_date' => '2017-03-10 13:19:12',
  'post_date_gmt' => '2017-03-10 13:19:12',
  'post_content' => '<!--themify_builder_static--><h1>Contact</h1>
 <h3>We love to hear from you, whether a complaint or a compliment. Get in touch now.</h3>
 
 <form action="https://themify.me/demo/themes/shoppe-music/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> 
 <label for="contact-0--contact-name">Your Name *</label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" required /> 
 <label for="contact-0--contact-email">Your Email *</label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" required /> 
 <label for="contact-0--contact-subject">Subject</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> 
 <button type="submit"> Send </button> 
 </form>
 
 
 
 
 
 <h3> Office Address </h3> <p>Oplication Block Street, Block 36,<br />Mexico City, Mexico<br />804538</p> 
 
 
 
 
 
 <h3> Office Hours </h3> <p>MON &#8211; FRIDAY: 12 Noon to 9 PM<br />SAT &#8211; SUN: 14 Noon to 12 PM</p> 
 
 
 
 
 
 <h3> Contact </h3> <p>Support: <a href="tel:1-800-268-8866">1-800-268-8866</a><br />Email: <a href="mailto:support@shoppe.com">support@shoppe.com</a></p><!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2017-11-01 18:00:52',
  'post_modified_gmt' => '2017-11-01 18:00:52',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?page_id=2592',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Contact<\\\\/h1>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_h1\\":\\"ffffff_1.00\\",\\"font_size_h1\\":\\"48\\",\\"line_height_h1\\":\\"60\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h1\\":\\"38\\",\\"line_height_h1\\":\\"50\\"},\\"cid\\":\\"c14\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"best-fit\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/contact.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"6950d1_0.59\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>We love to hear from you, whether a complaint or a compliment. Get in touch now.<\\\\/h3>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_h3\\":\\"30\\",\\"line_height_h3\\":\\"42\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_h3\\":\\"25\\",\\"line_height_h3\\":\\"35\\"},\\"cid\\":\\"c32\\"}},{\\"mod_name\\":\\"contact\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_border_inputs_apply_all\\":\\"1\\",\\"checkbox_border_send_apply_all\\":\\"1\\",\\"checkbox_padding_success_message_apply_all\\":\\"1\\",\\"checkbox_margin_success_message_apply_all\\":\\"1\\",\\"checkbox_border_success_message_apply_all\\":\\"1\\",\\"checkbox_padding_error_message_apply_all\\":\\"1\\",\\"checkbox_margin_error_message_apply_all\\":\\"1\\",\\"checkbox_border_error_message_apply_all\\":\\"1\\",\\"layout_contact\\":\\"style1\\",\\"mail_contact\\":\\"info@themify.me\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Your Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_subject_active\\":\\"yes\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Send\\"}}],\\"grid_width\\":\\"63.8549\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Office Address\\",\\"content_feature\\":\\"<p>Oplication Block Street, Block 36,<br \\\\/>Mexico City, Mexico<br \\\\/>804538<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"ti-location-arrow\\",\\"icon_color_feature\\":\\"434789_1.00\\",\\"link_options\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"font_color\\":\\"808080_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_color_title\\":\\"404040_1.00\\",\\"font_size_title\\":\\"24\\",\\"line_height_title\\":\\"44\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_title\\":\\"24\\",\\"line_height_title\\":\\"30\\"},\\"cid\\":\\"c40\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_stroke_feature\\":\\"3\\"}},{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Office Hours\\",\\"content_feature\\":\\"<p>MON - FRIDAY: 12 Noon to 9 PM<br \\\\/>SAT - SUN: 14 Noon to 12 PM<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"ti-time\\",\\"icon_color_feature\\":\\"434789_1.00\\",\\"link_options\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"font_color\\":\\"808080_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_color_title\\":\\"404040_1.00\\",\\"font_size_title\\":\\"24\\",\\"line_height_title\\":\\"44\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_title\\":\\"24\\",\\"line_height_title\\":\\"30\\"},\\"cid\\":\\"c44\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_stroke_feature\\":\\"3\\"}},{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Contact\\",\\"content_feature\\":\\"<p>Support: <a href=\\\\\\\\\\\\\\"tel:1-800-268-8866\\\\\\\\\\\\\\">1-800-268-8866<\\\\/a><br \\\\/>Email: <a href=\\\\\\\\\\\\\\"mailto:support@shoppe.com\\\\\\\\\\\\\\">support@shoppe.com<\\\\/a><\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"ti-email\\",\\"icon_color_feature\\":\\"434789_1.00\\",\\"link_options\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"font_color\\":\\"808080_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_color_title\\":\\"404040_1.00\\",\\"font_size_title\\":\\"24\\",\\"line_height_title\\":\\"44\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"font_size_title\\":\\"24\\",\\"line_height_title\\":\\"30\\"},\\"cid\\":\\"c48\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_stroke_feature\\":\\"3\\"}}],\\"grid_width\\":\\"32.9454\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"border_left_color\\":\\"e3e3e3_1.00\\",\\"border_left_width\\":\\"1\\",\\"custom_css_column\\":\\"contact-info\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"border_left_color\\":\\"ffffff_1.00\\",\\"border_left_width\\":\\"1\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2718,
  'post_date' => '2017-03-01 12:11:40',
  'post_date_gmt' => '2017-03-01 12:11:40',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur?

Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. ',
  'post_title' => 'Unplugged',
  'post_excerpt' => '',
  'post_name' => 'unplugged',
  'post_modified' => '2017-05-11 12:17:30',
  'post_modified_gmt' => '2017-05-11 12:17:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?post_type=product&#038;p=2718',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1494504995:216',
    '_edit_last' => '216',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
    'content_width' => 'default_width',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '2720',
    'post_image' => 'https://themify.me/demo/themes/shoppe-music/files/2017/05/album-8.jpg',
    '_yoast_wpseo_content_score' => '30',
    '_regular_price' => '29.50',
    '_sale_price' => '26.50',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.0.0',
    '_price' => '26.50',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2713,
  'post_date' => '2017-04-15 11:53:32',
  'post_date_gmt' => '2017-04-15 11:53:32',
  'post_content' => 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.

"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."

',
  'post_title' => 'Avenger',
  'post_excerpt' => '',
  'post_name' => 'avenger',
  'post_modified' => '2017-05-11 12:17:49',
  'post_modified_gmt' => '2017-05-11 12:17:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?post_type=product&#038;p=2713',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1494504995:216',
    '_edit_last' => '216',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
    'content_width' => 'default_width',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '2719',
    'post_image' => 'https://themify.me/demo/themes/shoppe-music/files/2017/05/album-7.jpg',
    '_yoast_wpseo_content_score' => '30',
    '_regular_price' => '30.90',
    'total_sales' => '1',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.0.0',
    '_price' => '30.90',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2717,
  'post_date' => '2017-04-11 11:55:22',
  'post_date_gmt' => '2017-04-11 11:55:22',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.',
  'post_title' => 'Odesza In Return',
  'post_excerpt' => '',
  'post_name' => 'odesza-in-return',
  'post_modified' => '2017-05-11 11:58:14',
  'post_modified_gmt' => '2017-05-11 11:58:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?post_type=product&#038;p=2717',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1494504995:216',
    '_edit_last' => '216',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
    'content_width' => 'default_width',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '2714',
    'post_image' => 'https://themify.me/demo/themes/shoppe-music/files/2017/03/album-6.jpg',
    '_yoast_wpseo_content_score' => '30',
    '_regular_price' => '25.50',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.0.0',
    '_price' => '25.50',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2667,
  'post_date' => '2017-03-08 11:33:30',
  'post_date_gmt' => '2017-03-08 11:33:30',
  'post_content' => 'Donec porttitor luctus mi a tristique. Vivamus tempus pretium dui, eget efficitur eros facilisis id. Vestibulum eget libero vitae nulla pretium porttitor ac vitae ipsum. Sed ac aliquam turpis. Nullam tellus enim, convallis ac neque id, dignissim tincidunt ligula. Proin tincidunt viverra maximus. Pellentesque eu sapien sapien. In nec felis id velit laoreet dapibus at varius metus. Vestibulum quis luctus odio. Praesent tristique convallis consequat. Fusce lacinia ante eu nunc lobortis aliquam.

Ut imperdiet metus eu augue scelerisque ultricies. Ut turpis turpis, sodales ac lacus quis, tincidunt tristique nisi. Pellentesque ac porta quam, nec varius nisi. Sed vitae condimentum enim. Suspendisse scelerisque ligula gravida massa pretium facilisis sed sit amet neque. Integer dictum mollis pulvinar. In egestas ligula urna, quis vulputate magna blandit vel.',
  'post_title' => 'Insurgency EP',
  'post_excerpt' => 'Sed eget tincidunt nulla, posuere elementum ligula.
Nulla facilisi. Praesent luctus, neque dictum feugiat maxim Suspendisse congue imperdiet sem vitae dapibus.',
  'post_name' => 'insurgency-ep',
  'post_modified' => '2017-05-11 11:54:46',
  'post_modified_gmt' => '2017-05-11 11:54:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-music/?post_type=product&#038;p=2667',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1494503722:216',
    '_edit_last' => '216',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":{\\"1\\":{\\"mod_name\\":\\"audio\\",\\"mod_settings\\":{\\"music_playlist\\":[{\\"audio_name\\":\\"I\\\\\\\\\\\'ve Not Over Yet\\",\\"audio_url\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/myuu-ItsNotOverYet.mp3\\"}],\\"hide_download_audio\\":\\"yes\\",\\"add_css_audio\\":\\"shadow\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}},\\"styling\\":[]}],\\"styling\\":[]},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'content_width' => 'default_width',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '1288.00',
    '_sale_price' => '1000.00',
    '_price' => '1000.00',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_stock' => NULL,
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.0.0',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_review_count' => '1',
    '_wc_average_rating' => '0',
    '_thumbnail_id' => '2715',
    '_tax_status' => 'taxable',
    '_default_attributes' => 
    array (
    ),
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2562,
  'post_date' => '2017-03-08 12:38:06',
  'post_date_gmt' => '2017-03-08 12:38:06',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Quiet Night Time',
  'post_excerpt' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.',
  'post_name' => 'quiet-night-time',
  'post_modified' => '2017-05-11 11:51:09',
  'post_modified_gmt' => '2017-05-11 11:51:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?post_type=product&#038;p=2562',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1494503454:216',
    '_edit_last' => '216',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":{\\"1\\":{\\"mod_name\\":\\"audio\\",\\"mod_settings\\":{\\"music_playlist\\":[{\\"audio_name\\":\\"I\\\\\\\\\\\'ve Not Over Yet\\",\\"audio_url\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/myuu-ItsNotOverYet.mp3\\"}],\\"hide_download_audio\\":\\"yes\\",\\"add_css_audio\\":\\"shadow\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}},\\"styling\\":[]}],\\"styling\\":[]},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'content_width' => 'default_width',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '2712',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '27.00',
    '_price' => '27.00',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_stock' => NULL,
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.0.0',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_review_count' => '0',
    '_wc_average_rating' => '0',
    '_tax_status' => 'taxable',
    '_default_attributes' => 
    array (
    ),
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    'post_image' => 'https://themify.me/demo/themes/shoppe-music/files/2017/03/album-4-1.jpg',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2567,
  'post_date' => '2017-03-09 12:40:14',
  'post_date_gmt' => '2017-03-09 12:40:14',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_title' => 'Mars',
  'post_excerpt' => 'Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_name' => 'mars',
  'post_modified' => '2017-05-11 11:45:30',
  'post_modified_gmt' => '2017-05-11 11:45:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?post_type=product&#038;p=2567',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1494503458:216',
    '_edit_last' => '216',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":{\\"1\\":{\\"mod_name\\":\\"audio\\",\\"mod_settings\\":{\\"music_playlist\\":[{\\"audio_name\\":\\"I\\\\\\\\\\\'ve Not Over Yet\\",\\"audio_url\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/myuu-ItsNotOverYet.mp3\\"}],\\"hide_download_audio\\":\\"yes\\",\\"add_css_audio\\":\\"shadow\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}},\\"styling\\":[]}],\\"styling\\":[]},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'content_width' => 'default_width',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '2711',
    'post_image' => 'https://themify.me/demo/themes/shoppe-music/files/2017/03/album-mars.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '26.00',
    '_price' => '26.00',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_stock' => NULL,
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.0.0',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_review_count' => '0',
    '_wc_average_rating' => '0',
    '_tax_status' => 'taxable',
    '_default_attributes' => 
    array (
    ),
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2568,
  'post_date' => '2017-03-10 02:41:45',
  'post_date_gmt' => '2017-03-10 02:41:45',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Under the Iron Sea',
  'post_excerpt' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.',
  'post_name' => 'under-the-iron-sea',
  'post_modified' => '2017-05-11 11:40:04',
  'post_modified_gmt' => '2017-05-11 11:40:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?post_type=product&#038;p=2568',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1494503456:216',
    '_edit_last' => '216',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":{\\"1\\":{\\"mod_name\\":\\"audio\\",\\"mod_settings\\":{\\"music_playlist\\":[{\\"audio_name\\":\\"I\\\\\\\\\\\'ve Not Over Yet\\",\\"audio_url\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/myuu-ItsNotOverYet.mp3\\"}],\\"hide_download_audio\\":\\"yes\\",\\"add_css_audio\\":\\"shadow\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}},\\"styling\\":[]}],\\"styling\\":[]},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'content_width' => 'default_width',
    'builder_switch_frontend' => '0',
    'post_image' => 'https://themify.me/demo/themes/shoppe-music/files/2017/03/album-2.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '26.90',
    '_price' => '26.90',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_stock' => NULL,
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.0.0',
    '_yoast_wpseo_content_score' => '30',
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_tax_status' => 'taxable',
    '_default_attributes' => 
    array (
    ),
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_thumbnail_id' => '2710',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2569,
  'post_date' => '2017-03-10 12:46:33',
  'post_date_gmt' => '2017-03-10 12:46:33',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Black Beatles',
  'post_excerpt' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
  'post_name' => 'black-beatles',
  'post_modified' => '2017-05-11 11:39:48',
  'post_modified_gmt' => '2017-05-11 11:39:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?post_type=product&#038;p=2569',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1494503456:216',
    '_edit_last' => '216',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":{\\"1\\":{\\"mod_name\\":\\"audio\\",\\"mod_settings\\":{\\"music_playlist\\":[{\\"audio_name\\":\\"I\\\\\\\\\\\'ve Not Over Yet\\",\\"audio_url\\":\\"https://themify.me/demo/themes/shoppe-music\\\\/files\\\\/2017\\\\/03\\\\/myuu-ItsNotOverYet.mp3\\"}],\\"hide_download_audio\\":\\"yes\\",\\"add_css_audio\\":\\"shadow\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"20\\",\\"padding_right\\":\\"30\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}},\\"styling\\":[]}],\\"styling\\":[]},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[]}],\\"styling\\":[]}]',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'content_width' => 'default_width',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '25.90',
    '_price' => '25.90',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_stock' => NULL,
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.0.0',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_review_count' => '0',
    '_wc_average_rating' => '0',
    '_tax_status' => 'taxable',
    '_default_attributes' => 
    array (
    ),
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_thumbnail_id' => '2708',
    'post_image' => 'https://themify.me/demo/themes/shoppe-music/files/2017/03/album-1.jpg',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
  ),
  'has_thumbnail' => true,
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 13,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Copmany',
  'post_excerpt' => '',
  'post_name' => 'copmany',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/copmany/',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '13',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 18,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Order Status',
  'post_excerpt' => '',
  'post_name' => 'order-status',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/order-status/',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '18',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2603,
  'post_date' => '2017-03-14 06:14:25',
  'post_date_gmt' => '2017-03-14 06:14:25',
  'post_content' => '',
  'post_title' => 'Order Status',
  'post_excerpt' => '',
  'post_name' => 'order-status-2',
  'post_modified' => '2017-03-14 06:14:25',
  'post_modified_gmt' => '2017-03-14 06:14:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?p=2603',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2603',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-support-menu',
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2597,
  'post_date' => '2017-03-10 13:24:23',
  'post_date_gmt' => '2017-03-10 13:24:23',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '2597',
  'post_modified' => '2017-03-10 13:25:01',
  'post_modified_gmt' => '2017-03-10 13:25:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?p=2597',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2580',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2585,
  'post_date' => '2017-03-10 13:11:24',
  'post_date_gmt' => '2017-03-10 13:11:24',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '2585',
  'post_modified' => '2017-03-10 13:11:24',
  'post_modified_gmt' => '2017-03-10 13:11:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?p=2585',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2583',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_icon' => 'ti-user',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'icon-menu',
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 14,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Our Story',
  'post_excerpt' => '',
  'post_name' => 'our-story',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/our-story/',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '14',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 19,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Refund Policies',
  'post_excerpt' => '',
  'post_name' => 'refund-policies',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/refund-policies/',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '19',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2602,
  'post_date' => '2017-03-14 06:14:25',
  'post_date_gmt' => '2017-03-14 06:14:25',
  'post_content' => '',
  'post_title' => 'Orders & Payments',
  'post_excerpt' => '',
  'post_name' => 'orders-payments',
  'post_modified' => '2017-03-14 06:14:25',
  'post_modified_gmt' => '2017-03-14 06:14:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?p=2602',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2602',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/shopmusic/my-account/orders/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-support-menu',
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2596,
  'post_date' => '2017-03-10 13:24:23',
  'post_date_gmt' => '2017-03-10 13:24:23',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '2596',
  'post_modified' => '2017-03-10 13:25:01',
  'post_modified_gmt' => '2017-03-10 13:25:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?p=2596',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2588',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 15,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Locations',
  'post_excerpt' => '',
  'post_name' => 'locations',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/locations/',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '15',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 20,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Complaints',
  'post_excerpt' => '',
  'post_name' => 'complaints',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/complaints/',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '20',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 33,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Archive Layouts',
  'post_excerpt' => '',
  'post_name' => 'archive-layouts',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/archive-layouts/',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '2511',
    '_menu_item_object_id' => '33',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2604,
  'post_date' => '2017-03-14 06:14:25',
  'post_date_gmt' => '2017-03-14 06:14:25',
  'post_content' => '',
  'post_title' => 'Returns & Exchanges',
  'post_excerpt' => '',
  'post_name' => 'returns-exchanges',
  'post_modified' => '2017-03-14 06:14:25',
  'post_modified_gmt' => '2017-03-14 06:14:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?p=2604',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2604',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-support-menu',
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2595,
  'post_date' => '2017-03-10 13:24:23',
  'post_date_gmt' => '2017-03-10 13:24:23',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '2595',
  'post_modified' => '2017-03-10 13:25:01',
  'post_modified_gmt' => '2017-03-10 13:25:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?p=2595',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2590',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 16,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Team',
  'post_excerpt' => '',
  'post_name' => 'team',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/team/',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '16',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 21,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Help',
  'post_excerpt' => '',
  'post_name' => 'help',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/help/',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '21',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2605,
  'post_date' => '2017-03-14 06:14:25',
  'post_date_gmt' => '2017-03-14 06:14:25',
  'post_content' => '',
  'post_title' => 'FAQ',
  'post_excerpt' => '',
  'post_name' => 'faq',
  'post_modified' => '2017-03-14 06:14:25',
  'post_modified_gmt' => '2017-03-14 06:14:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?p=2605',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2605',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-support-menu',
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 2594,
  'post_date' => '2017-03-10 13:24:23',
  'post_date_gmt' => '2017-03-10 13:24:23',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '2594',
  'post_modified' => '2017-03-10 13:25:01',
  'post_modified_gmt' => '2017-03-10 13:25:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/?p=2594',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '2592',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 17,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Investors',
  'post_excerpt' => '',
  'post_name' => 'investors',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/investors/',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '17',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 22,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/contact/',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '22',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 32,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Product Single',
  'post_excerpt' => '',
  'post_name' => 'product-single',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/product-single/',
  'menu_order' => 8,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '2511',
    '_menu_item_object_id' => '32',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 29,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'WooCommerce Product Categories',
  'post_excerpt' => '',
  'post_name' => 'woocommerce-product-categories',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/woocommerce-product-categories/',
  'menu_order' => 13,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '2511',
    '_menu_item_object_id' => '29',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#WC_Widget_Product_Categories',
    '_themify_menu_widget' => 
    array (
      'title' => 'Product Categories',
      'orderby' => 'name',
      'count' => '1',
      'hierarchical' => '1',
    ),
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 30,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'WooCommerce Top Rated Products',
  'post_excerpt' => '',
  'post_name' => 'woocommerce-top-rated-products',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/woocommerce-top-rated-products/',
  'menu_order' => 14,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '2511',
    '_menu_item_object_id' => '30',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#WC_Widget_Top_Rated_Products',
    '_themify_menu_widget' => 
    array (
      'title' => 'Popular',
      'number' => '2',
    ),
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 23,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Layouts',
  'post_excerpt' => '',
  'post_name' => 'layouts',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/layouts/',
  'menu_order' => 21,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '23',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
    '_themify_mega_menu_column' => '1',
    '_themify_mega_menu_columns_layout' => '6-3-3',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 24,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Header',
  'post_excerpt' => '',
  'post_name' => 'header',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/header/',
  'menu_order' => 22,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '23',
    '_menu_item_object_id' => '24',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
    '_themify_dropdown_columns' => '2',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}

$post = array (
  'ID' => 28,
  'post_date' => '2017-03-10 12:16:36',
  'post_date_gmt' => '2017-03-10 12:16:36',
  'post_content' => '',
  'post_title' => 'Footer',
  'post_excerpt' => '',
  'post_name' => 'footer',
  'post_modified' => '2017-03-10 12:16:36',
  'post_modified_gmt' => '2017-03-10 12:16:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shopmusic/2017/03/10/footer/',
  'menu_order' => 37,
  'post_type' => 'nav_menu_item',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '23',
    '_menu_item_object_id' => '28',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
  ),
);

if( ERASEDEMO ) {
	themify_undo_import_post( $post );
} else {
	themify_import_post( $post );
}


function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_nav_menu" );
$widgets[1002] = array (
  'title' => 'Support',
  'nav_menu' => themify_import_get_term_id_from_slug( "" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_woocommerce_product_categories" );
$widgets[1003] = array (
  'title' => 'Categories',
  'orderby' => 'name',
  'dropdown' => 0,
  'count' => 0,
  'hierarchical' => 1,
  'show_children_only' => 0,
  'hide_empty' => 0,
);
update_option( "widget_woocommerce_product_categories", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1004] = array (
  'title' => '',
  'text' => 'Shoppe is a powerful shop theme created by Themify. It’s powered by WooCommerce and is highly customizable.

[themify_button link="https://themify.me/themes/shoppe" style="small outline black rect"]Download[/themify_button]',
  'filter' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_archives" );
$widgets[1005] = array (
  'title' => '',
  'count' => 0,
  'dropdown' => 0,
);
update_option( "widget_archives", $widgets );

$widgets = get_option( "widget_meta" );
$widgets[1006] = array (
  'title' => '',
);
update_option( "widget_meta", $widgets );

$widgets = get_option( "widget_search" );
$widgets[1007] = array (
  'title' => '',
);
update_option( "widget_search", $widgets );

$widgets = get_option( "widget_categories" );
$widgets[1008] = array (
  'title' => '',
  'count' => 0,
  'hierarchical' => 0,
  'dropdown' => 0,
);
update_option( "widget_categories", $widgets );

$widgets = get_option( "widget_recent-posts" );
$widgets[1009] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-posts", $widgets );

$widgets = get_option( "widget_recent-comments" );
$widgets[1010] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-comments", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1011] = array (
  'nav_menu' => themify_import_get_term_id_from_slug( "footer-support-menu" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1012] = array (
  'title' => 'Search',
  'text' => '[searchandfilter id="sidebar_filter"]',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1013] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => 'on',
  'icon_size' => 'icon-large',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1014] = array (
  'title' => '',
  'text' => '<div class="payment-method">
<span><i class="fa fa-cc-visa"></i></span>
<span><i class="fa fa-cc-mastercard"></i></span>
<span><i class="fa fa-cc-paypal"></i></span>
</div>',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_mc4wp_form_widget" );
$widgets[1015] = array (
  'title' => '',
);
update_option( "widget_mc4wp_form_widget", $widgets );



$sidebars_widgets = array (
  'footer-widget-4' => 
  array (
    0 => 'nav_menu-1002',
  ),
  'wp_inactive_widgets' => 
  array (
    0 => 'woocommerce_product_categories-1003',
    1 => 'text-1004',
    2 => 'archives-1005',
    3 => 'meta-1006',
    4 => 'search-1007',
    5 => 'categories-1008',
    6 => 'recent-posts-1009',
    7 => 'recent-comments-1010',
  ),
  'below-logo-widget' => 
  array (
    0 => 'nav_menu-1011',
  ),
  'sidebar-shop' => 
  array (
    0 => 'text-1012',
  ),
  'footer-widget-1' => 
  array (
    0 => 'themify-social-links-1013',
  ),
  'footer-widget-2' => 
  array (
    0 => 'text-1014',
  ),
  'footer-widget-3' => 
  array (
    0 => 'mc4wp_form_widget-1015',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
$menu = get_terms( "nav_menu", array( "slug" => "icon-menu" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["icon-menu"] = $menu[0]->term_id;
$menu = get_terms( "nav_menu", array( "slug" => "" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["footer-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:117:{s:16:"setting-page_404";s:1:"0";s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:12:"sidebar-none";s:27:"setting-default_post_layout";s:5:"grid4";s:27:"setting-post_content_layout";s:8:"polaroid";s:20:"setting-post_masonry";s:2:"no";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"excerpt";s:25:"setting-default_more_text";s:9:"Read More";s:20:"setting-excerpt_more";s:1:"1";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:25:"setting-default_post_meta";s:3:"yes";s:25:"setting-default_post_date";s:2:"no";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:12:"sidebar-none";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:31:"setting-image_post_single_width";s:4:"1160";s:32:"setting-image_post_single_height";s:3:"550";s:27:"setting-default_page_layout";s:12:"sidebar-none";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1024";s:43:"setting-customizer_responsive_design_tablet";s:3:"716";s:43:"setting-customizer_responsive_design_mobile";s:3:"414";s:33:"setting-mobile_menu_trigger_point";s:4:"1000";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:26:"setting-page_builder_cache";s:2:"on";s:18:"setting-cache_gzip";s:2:"on";s:27:"setting-script_minification";s:7:"disable";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:16:"header-logo-left";s:28:"setting-exclude_site_tagline";s:2:"on";s:21:"setting-footer_design";s:12:"footer-block";s:32:"setting-exclude_footer_site_logo";s:2:"on";s:27:"setting-exclude_footer_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-3col";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:39:"settings-footer_banner_twitter_username";s:8:"@themify";s:35:"settings-footer_banner_twitter_link";s:27:"https://twitter.com/themify";s:36:"settings-footer_banner_twitter_image";s:76:"https://themify.me/demo/themes/shoppe/files/2016/11/footer-share-twitter.jpg";s:40:"settings-footer_banner_facebook_username";s:7:"Themify";s:36:"settings-footer_banner_facebook_link";s:32:"https://www.facebook.com/themify";s:37:"settings-footer_banner_facebook_image";s:77:"https://themify.me/demo/themes/shoppe/files/2016/11/footer-share-facebook.jpg";s:41:"settings-footer_banner_pinterest_username";s:7:"Themify";s:37:"settings-footer_banner_pinterest_link";s:26:"https://www.pinterest.com/";s:38:"settings-footer_banner_pinterest_image";s:78:"https://themify.me/demo/themes/shoppe/files/2016/11/footer-share-pinterest.jpg";s:24:"setting-footer_text_left";s:41:"© 2017 Shoppe Music. All Rights Reserved";s:30:"setting-footer_text_right_hide";s:4:"hide";s:19:"setting-shop_layout";s:12:"sidebar-none";s:27:"setting-shop_archive_layout";s:12:"sidebar-none";s:23:"setting-products_layout";s:5:"grid4";s:29:"setting-shop_masonry_disabled";s:2:"on";s:27:"setting-product_post_gutter";s:6:"gutter";s:23:"setting-products_slider";s:6:"enable";s:30:"setting-shop_products_per_page";s:1:"9";s:23:"setting-hide_shop_count";s:2:"on";s:25:"setting-hide_shop_sorting";s:2:"on";s:23:"setting-hide_shop_title";s:2:"on";s:46:"setting-default_product_index_image_post_width";s:3:"262";s:47:"setting-default_product_index_image_post_height";s:3:"262";s:29:"setting-single_product_layout";s:12:"sidebar-none";s:28:"setting-product_image_layout";s:8:"img-left";s:47:"setting-default_product_single_image_post_width";s:3:"500";s:48:"setting-default_product_single_image_post_height";s:3:"500";s:28:"setting-product_gallery_type";s:4:"zoom";s:30:"setting-related_products_limit";s:1:"3";s:21:"setting-wishlist_page";s:4:"2702";s:18:"setting-cart_style";s:8:"dropdown";s:19:"setting-spark_color";s:7:"#a86fbb";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:101:"https://themify.me/demo/themes/shoppe/wp-content/themes/themify-shoppe/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:102:"https://themify.me/demo/themes/shoppe/wp-content/themes/themify-shoppe/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:105:"https://themify.me/demo/themes/shoppe/wp-content/themes/themify-shoppe/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:101:"https://themify.me/demo/themes/shoppe/wp-content/themes/themify-shoppe/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:103:"https://themify.me/demo/themes/shoppe/wp-content/themes/themify-shoppe/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:8:"Facebook";s:32:"setting-link_link_themify-link-6";s:32:"https://www.facebook.com/themify";s:33:"setting-link_ficon_themify-link-6";s:11:"ti-facebook";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:7:"Twitter";s:32:"setting-link_link_themify-link-5";s:27:"https://twitter.com/themify";s:33:"setting-link_ficon_themify-link-5";s:10:"ti-twitter";s:33:"setting-link_type_themify-link-10";s:9:"font-icon";s:34:"setting-link_title_themify-link-10";s:9:"Instagram";s:33:"setting-link_link_themify-link-10";s:1:"#";s:34:"setting-link_ficon_themify-link-10";s:12:"fa-instagram";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_title_themify-link-9";s:9:"Pinterest";s:32:"setting-link_link_themify-link-9";s:25:"https://www.pinterest.com";s:33:"setting-link_ficon_themify-link-9";s:12:"ti-pinterest";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:7:"YouTube";s:32:"setting-link_link_themify-link-8";s:39:"https://www.youtube.com/user/themifyme/";s:33:"setting-link_ficon_themify-link-8";s:10:"ti-youtube";s:33:"setting-link_type_themify-link-11";s:9:"font-icon";s:34:"setting-link_title_themify-link-11";s:11:"Google Plus";s:33:"setting-link_link_themify-link-11";s:1:"#";s:34:"setting-link_ficon_themify-link-11";s:9:"ti-google";s:22:"setting-link_field_ids";s:379:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-6":"themify-link-6","themify-link-5":"themify-link-5","themify-link-10":"themify-link-10","themify-link-9":"themify-link-9","themify-link-8":"themify-link-8","themify-link-11":"themify-link-11"}";s:23:"setting-link_field_hash";s:2:"12";s:30:"setting-page_builder_is_active";s:6:"enable";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:4:"skin";s:98:"https://themify.me/demo/themes/shoppe-music/wp-content/themes/themify-shoppe/skins/music/style.css";}<?php $themify_data = unserialize( ob_get_clean() );

	// fix the weird way "skin" is saved
	if( isset( $themify_data['skin'] ) ) {
		$parsed_skin = parse_url( $themify_data['skin'], PHP_URL_PATH );
		$basedir_skin = basename( dirname( $parsed_skin ) );
		$themify_data['skin'] = trailingslashit( get_template_directory_uri() ) . 'skins/' . $basedir_skin . '/style.css';
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();