<?php
/***************************************************************************
 *						Theme Modules
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  					Copyright (C) Themify
 * 						https://themify.me
 *
 *  To add custom modules to the theme, create a new 'custom-modules.php' file in the theme folder.
 *  They will be added to the theme automatically.
 * 
 ***************************************************************************/

/**
 * Markup for theme design options
 * @param array $data
 * @return string
 */
function themify_theme_design_controls( $data = array() ) {
	/**
	 * Module markup
	 * @var string
	 */
	$html = '<div class="themify-info-link">'. __( 'Here you can set the theme appearance site-wide. The appearance settings here can be override on individual post/page &gt; edit &gt; Themify Custom Panel  &gt; Page Appearance).', 'themify' ) .'</div>';


	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-color_design';

	/**
	 * Header Design
	 * @var array
	 */
	$design_options = themify_theme_header_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-header_design';

	// Store items to hide
	$html .= '<div class="group-hide" data-hide="none header-left-pane header-minbar-left header-minbar-right header-boxed-content header-right-pane">';

		/**
		 * Header Design
		 */

		$html .= '<p class="clearfix">
						<span class="label">' . __( 'Header Design', 'themify' ) . '</span>';
		$val = themify_check( $pre ) ? themify_get( $pre ) : 'header-logo-center';
		$html .= '<span class="preview-icon-wrapper">';
		unset( $design_options[0] );
		foreach ( $design_options as $option ) {
			$class = ( $val == $option['value'] ) ? 'selected' : '';

			$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}

		$html .= '	<input type="hidden" name="' . esc_attr( $pre ) . '" class="val" value="' . esc_attr( $val ) . '" />';
		$html .= '</span>';
					'</p>';

		/**
		 * Fixed header
		 */
		$html .= sprintf('<p class="hide-if none header-slide-left header-slide-right header-boxed-content header-left-pane header-right-pane header-minbar-left header-minbar-right pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-fixed_header_disabled',
			checked( themify_get( 'setting-fixed_header_disabled' ), 'on', false ),
			__('Disable Sticky Header.', 'themify')
		);
		
		/**
		 * Full height header
		 */
		$key = 'setting-full_height_header';
		$html .= sprintf('<p class="hide-if none header-logo-left header-left-pane header-minbar-left header-minbar-right header-slide-left header-slide-right header-top-bar header-boxed-layout header-boxed-content header-right-pane header-stripe header-logo-center header-overlay pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s value="yes"/> %3$s</label>
			<br><small>%4$s</small>
			</p>',
			$key,
			checked( themify_get( $key ), 'yes', false ),
			__( 'Full Height Header.', 'themify' ),
			__( 'Full height will display the container in 100% viewport height', 'themify' )
		);
		
		/**
		 * Exclude Site Logo
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_site_logo',
			checked( themify_get( 'setting-exclude_site_logo' ), 'on', false ),
			__('Exclude Site Logo.', 'themify')
		);

		/**
		 * Exclude Site Tagline
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_site_tagline',
			checked( themify_get( 'setting-exclude_site_tagline' ), 'on', false ),
			__('Exclude Site Tagline.', 'themify')
		);

		/**
		 * Exclude Cart Icon
		 */
		if( themify_is_woocommerce_active() ) {
			$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
				'setting-exclude_cart',
				checked( themify_get( 'setting-exclude_cart' ), 'on', false ),
				__('Exclude Cart Icon.', 'themify')
			);
			
			$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
				'setting-exclude_wishlist',
				checked( themify_get( 'setting-exclude_wishlist' ), 'on', false ),
				__('Exclude Wishlist Icon.', 'themify')
			);
		}

		/**
		 * Exclude Search Form
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_search_button',
			checked( themify_get( 'setting-exclude_search_button' ), 'on', false ),
			__('Exclude Search Icon.', 'themify')
		);

		/**
		 * Exclude Menu Navigation
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_menu_navigation',
			checked( themify_get( 'setting-exclude_menu_navigation' ), 'on', false ),
			__('Exclude Menu Navigation.', 'themify')
		);

		/**
		 * Exclude Top Bar Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_top_bar_widgets',
			checked( themify_get( 'setting-exclude_top_bar_widgets' ), 'on', false ),
			__('Exclude Top Bar Widgets.', 'themify')
		);

	// End group of elements to hide
	$html .= '</div><!-- /.group-hide -->';

	/**
	 * Footer Design
	 * @var array
	 */
	$design_options = themify_theme_footer_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$key = 'setting-footer_design';

	// Store items to hide
	$html .= '<div class="group-hide" data-hide="none">';

		/**
		 * Footer Design
		 */
		$html .= '<p>
						<span class="label">' . __( 'Footer Design', 'themify' ) . '</span>';
		$val = themify_check( $key ) ? themify_get( $key ) : '';
		foreach ( $design_options as $option ) {
                        if($option['value']==='default'){
                            continue;
                        }
                        elseif($option['value']==='footer-block'){
                            $option['selected'] = true;
                        }
			if ( ( '' == $val || ! $val ) && $option['selected'] ) {
				$val = $option['value'];
			}

			$class = ( $val == $option['value'] ) ? 'selected' : '';

			$html .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI . '/' . $option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}

		$html .= '	<input type="hidden" name="' . esc_attr( $key ) . '" class="val" value="' . esc_attr( $val ) . '" />
					</p>';

		// Exclusions

		$key = 'setting-exclude_';

		/**
		 * Exclude Site Logo
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_site_logo',
			checked( themify_get( $key . 'footer_site_logo' ), 'on', false ),
			__('Exclude Site Logo.', 'themify')
		);

		/**
		 * Exclude Footer Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_widgets',
			checked( themify_get( $key . 'footer_widgets' ), 'on', false ),
			__('Exclude Footer Widgets.', 'themify')
		);

		/**
		 * Exclude Menu Navigation
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_menu_navigation',
			checked( themify_get( $key . 'footer_menu_navigation' ), 'on', false ),
			__('Exclude Menu Navigation.', 'themify')
		);

		/**
		 * Exclude Footer Texts
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_texts',
			checked( themify_get( $key . 'footer_texts' ), 'on', false ),
			__('Exclude Footer Text', 'themify')
		);

		/**
		 * Exclude Footer Back to Top
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_back',
			checked( themify_get( $key . 'footer_back' ), 'on', false ),
			__('Exclude Back to Top button', 'themify')
		);

        /**
         * Use Floating Back to Top
         */
        $html .= sprintf('<p class="hide-if none pushlabel" data-show-if-element="[name=setting-exclude_footer_back]" data-show-if-value="false"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
            'setting-use_float_back',
            checked( themify_get( 'setting-use_float_back' ), 'on', false ),
            __('Use Floating Back to Top Button', 'themify')
        );

		/**
		 * Revealing footer
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-revealing_footer',
			checked( themify_get( 'setting-revealing_footer' ), 'on', false ),
			__( 'Enable Revealing Footer', 'themify' )
		);

	// End group of elements to hide
	$html .= '</div><!-- /.group-hide -->';

	$options = array(
		array(
			'value' => 'footerwidget-4col',
			'img' => 'themify/img/sidebars/4col.png',
			'title' => __('Widgets 4 Columns', 'themify')),
		array(
			'value' => 'footerwidget-3col',
			'img' => 'themify/img/sidebars/3col.png',
			'title' => __('Widgets 3 Columns', 'themify'),
			'selected' => true),
		array(
			'value' => 'footerwidget-2col',
			'img' => 'themify/img/sidebars/2col.png',
			'title' => __('Widgets 2 Columns', 'themify')),
		array(
			'value' => 'footerwidget-1col',
			'img' => 'themify/img/sidebars/1col.png',
			'title' => __('Widgets 1 Column', 'themify')),
		array(
			'value' => 'none',
			'img' => 'themify/img/sidebars/none.png',
			'title' => __('No Widgets', 'themify'))
	);
	$val = themify_get( 'setting-footer_widgets' );
	$html.='<div data-show-if-element="[name=setting-footer_design]"  data-show-if-value=' . '["footer-block","footer-left-column","footer-right-column","footer-horizontal-left","footer-horizontal-right"]' . '>';
	$html .= '<p><span class="label">' . __( 'Footer Widgets', 'themify' ) . '</span>';

	foreach($options as $option){
		if(('' == $val || !$val || !isset($val)) && isset($option['selected']) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$html .= '<a href="#" class="' . esc_attr( 'preview-icon ' . $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	$html .= '<input type="hidden" name="setting-footer_widgets" class="val" value="' . esc_attr( $val ) . '" />';

	$html .= '</p>';
		
		// Footer widget position
	$key = 'setting-footer_widget_position';
	$html .= '<p data-show-if-element="[name=setting-footer_widgets]"  data-show-if-value=' . '["footerwidget-1col","footerwidget-2col","footerwidget-3col","footerwidget-4col"]' . '><span class="label">' . __( 'Footer Widgets Position', 'themify' ) . '</span>';
	$html.='<select name="' . $key . '">' . themify_options_module( array(
				array( 'name' => __( 'After Footer Text', 'themify' ), 'value' => '' ),
				array( 'name' => __( 'Before Footer Text', 'themify' ), 'value' => 'top' ),
		), $key ) . '
		</select></p>';
	$html.='</div>';
	return $html;
}

/**
 * Image Filter Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_image_filter( $data = array() ) {
	$data = themify_get_data();
	/**
	 * Theme Settings Option Key Prefix
	 *
	 * @var string
	 */
	$key = 'setting-imagefilter_options';

	/**
	 * Module markup
	 * @var string
	 */
	$out = '<p>
				<span class="label">' . __( 'Image Filter', 'themify' ) . '</span>
				<select name="' . $key . '">' . themify_options_module( array(
					array( 'name' => __( 'None', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Grayscale', 'themify' ), 'value' => 'grayscale' ),
					array( 'name' => __( 'Sepia', 'themify' ), 'value' => 'sepia' ),
					array( 'name' => __( 'Blur', 'themify' ), 'value' => 'blur' ),
				), $key ) . '
				</select>
			</p>';


	$out .= '<p>
				<span class="label">' . __( 'Image Hover Filter', 'themify' ) . '</span>
				<select name="' . $key . '_hover">' . themify_options_module( array(
					array( 'name' => __( 'None', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Grayscale', 'themify' ), 'value' => 'grayscale' ),
					array( 'name' => __( 'Sepia', 'themify' ), 'value' => 'sepia' ),
					array( 'name' => __( 'Blur', 'themify' ), 'value' => 'blur' ),
				), $key . '_hover' ) . '
				</select>
			</p>';

	$key1 = 'setting-imagefilter_applyto';
	$preset = themify_check( $key1 ) ? themify_get( $key1 ) : 'featuredonly';
	$out .= '<p>
				<span class="label">' . __( 'Apply to', 'themify' ) . '</span>' .
		        sprintf('<label for="%1$s"><input type="radio" id="%1$s" name="%1$s" %2$s value="featuredonly" /> %3$s</label>',
				$key1, checked( $preset, 'featuredonly', false ), __( 'Featured Images Only', 'themify' ) ) .
				'<br/>
				<span class="pushlabel">' .
		        sprintf('<label for="%1$s"><input type="radio" id="%1$s" name="%1$s" %2$s value="allimages" /> %3$s</label>',
				$key1, checked( themify_get( $key1 ), 'allimages', false ), __( 'All Images', 'themify' ) ) . '
				</span>
			</p>';

	return $out;
}


/**
 * Default Index Layout Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_default_layout( $data = array() ){
	$data = themify_get_data();

	/**
	 * Theme Settings Option Key Prefix
	 * @var string
	 */
	$prefix = 'setting-default_';
	
	if ( ! isset( $data[$prefix . 'more_text'] ) || '' == $data[$prefix . 'more_text'] ) {
		$more_text = __( 'More', 'themify' );
	} else {
		$more_text = $data[$prefix . 'more_text'];
	}

	/**
	 * Tertiary options <blank>|yes|no
	 * @var array
	 */
	$default_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Yes', 'themify'), 'value' => 'yes'),
		array('name' => __('No', 'themify'), 'value' => 'no')
	);

	/**
	 * Default options 'yes', 'no'
	 * @var array
	 */
	$binary_options = array(
		array('name'=>__('Yes', 'themify'),'value'=>'yes'),
		array('name'=>__('No', 'themify'),'value'=>'no')
	);

	/**
	 * Post content display options
	 * @var array
	 */
	$default_display_options = array(
		array('name' => __('Full Content', 'themify'),'value' => 'content'),
		array('name' => __('Excerpt', 'themify'),'value' => 'excerpt'),
		array('name' => __('None', 'themify'),'value' => 'none')
	);

	/**
	 * Post layout options
	 * @var array
	 */
	$default_post_layout_options = array(
		array('value' => 'list-post', 'img' => 'images/layout-icons/list-post.png', 'title' => __( 'List Post', 'themify' ), "selected" => true),
		array('value' => 'grid4', 'img' => 'images/layout-icons/grid4.png', 'title' => __( 'Grid 4', 'themify' )),
		array('value' => 'grid3', 'img' => 'images/layout-icons/grid3.png', 'title' => __( 'Grid 3', 'themify' )),
		array('value' => 'grid2', 'img' => 'images/layout-icons/grid2.png', 'title' => __( 'Grid 2', 'themify' )),
		array('value' => 'list-large-image','img' => 'images/layout-icons/list-large-image.png', 'title' => __('List Large Image', 'themify')),
		array('value' => 'auto_tiles', 'img' => 'images/layout-icons/auto-tiles.png', 'title' => __('Auto Tiles', 'themify'))
	);

	/**
	 * Sidebar placement options
	 * @var array
	 */
	$sidebar_location_options = array(
		array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'selected' => true, 'title' => __('Sidebar Right', 'themify')),
		array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
		array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png', 'title' => __('No Sidebar', 'themify'))
	);

	/**
	 * Image alignment options
	 * @var array
	 */
	$alignment_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Left', 'themify'), 'value' => 'left'),
		array('name' => __('Right', 'themify'), 'value' => 'right')
	);

	/**
	 * Entry media position, above or below the title
	 */
	$media_position = array(
		array('name'=>__('Above Post Title', 'themify'), 'value'=>'above'),
		array('name'=>__('Below Post Title', 'themify'), 'value'=>'below'),
	);

	/**
	 * HTML for settings panel
	 * @var string
	 */
	$output = '<div class="themify-info-link">' . __( 'Here you can set the <a href="https://themify.me/docs/default-layouts">Default Layouts</a> for WordPress archive post layout (category, search, archive, tag pages, etc.), single post layout (single post page), and the static Page layout. The default single post and page layout can be override individually on the post/page &gt; edit &gt; Themify Custom Panel.', 'themify' ) . '</div>';
	
	/**
	 * Index Sidebar Option
	 */
	$output .= '<p>
					<span class="label">' . __('Archive Sidebar Option', 'themify') . '</span>';
	$val = isset( $data[$prefix.'layout'] ) ? $data[$prefix.'layout'] : '';
	foreach($sidebar_location_options as $option){
		if(($val == '' || !$val || !isset($val)) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';	
	}
	
	$output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Post Layout
	 */
	$output .= '<p>
					<span class="label">' . __('Post Layout', 'themify') . '</span>';
	$val = isset( $data[$prefix.'post_layout'] ) ? $data[$prefix.'post_layout'] : '';
	foreach($default_post_layout_options as $option){
		if(($val == '' || !$val || !isset($val)) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';	
	}

	$output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'post_layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Post Content Style
	 */
	$output .= '<p data-show-if-element="[name=setting-default_post_layout]" data-show-if-value=' . '["grid2","grid3","grid4","list-post"]' . '>
					<span class="label">' . __( 'Post Content Style', 'themify' ) . '</span>
					<select name="setting-post_content_layout">'.
						themify_options_module( array(
							array( 'name' => __( 'Default', 'themify' ), 'value' => '' ),
							array( 'name' => __( 'Overlay', 'themify' ), 'value' => 'overlay' ),
							array( 'name' => __( 'Polaroid', 'themify' ), 'value' => 'polaroid' ),
							array( 'name' => __( 'Boxed', 'themify' ), 'value' => 'boxed' ),
							array( 'name' => __( 'Flip', 'themify' ), 'value' => 'flip' )
						), 'setting-post_content_layout' ) . '
					</select>
				</p>';

	/**
	 * Enable Masonry
	 */
	$output .=	'<p data-show-if-element="[name=setting-default_post_layout]" data-show-if-value=' . '["grid2","grid3","grid4"]' . '>
					<span class="label">' . __('Post Masonry', 'themify') . '</span>
					<select name="setting-post_masonry">' .
						themify_options_module($binary_options, 'setting-post_masonry') . '
					</select>
				</p>';

	/**
	 * Post Gutter
	 */
	$output .= '<p>
					<span class="label">' . __( 'Post Gutter', 'themify' ) . '</span>
					<select name="setting-post_gutter">'.
						themify_options_module( array(
							array( 'name' => __( 'Default', 'themify' ), 'value' => 'gutter' ),
							array( 'name' => __( 'No gutter', 'themify' ), 'value' => 'no-gutter' )
						), 'setting-post_gutter' ) . '
					</select>
				</p>';

	/**
	 * Display Content
	 */
	$output .= '<p>
					<span class="label">' . __('Display Content', 'themify') . '</span> 
					<select name="' . esc_attr( $prefix ) . 'layout_display">'.
						themify_options_module($default_display_options, $prefix.'layout_display').'
					</select>
				</p>';

	/**
	 * Excerpt length
	 */
	$output .= '<p style="display:none">
					<span class="pushlabel vertical-grouped">
						<label>
							<input class="width2" type="text" value="' . ( isset( $data[ $prefix . 'excerpt_length' ] ) ? esc_attr( $data[ $prefix . 'excerpt_length' ] ) : '' ) . '" name="' . esc_attr( $prefix ) . 'excerpt_length"> '
							. __( 'Excerpt length (enter number of words)', 'themify' ) . '
						</label>
					</span>
				</p>';
	
	/**
	 * More Text
	 */
	$output .= '<p>
					<span class="label">' . __('More Text', 'themify') . '</span>
					<input type="text" name="' . esc_attr( $prefix ) . 'more_text" value="' . esc_attr( $more_text ) . '">
					
					<span class="pushlabel vertical-grouped"><label for="setting-excerpt_more"><input type="checkbox" value="1" id="setting-excerpt_more" name="setting-excerpt_more" '.checked( themify_get( 'setting-excerpt_more' ), 1, false ).'/> ' . __('Display more link button in excerpt mode as well.', 'themify') . '</label></span>
				</p>';

	/**
	 * Order & OrderBy Options
	 */
	$output .= themify_post_sorting_options('setting-index_order', $data);
				
	/**
	 * Hide Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_title">' .
						themify_options_module($default_options, $prefix.'post_title') . '
					</select>
				</p>';
	
	/**
	 * Unlink Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Unlink Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_title">' .
						themify_options_module($default_options, $prefix.'unlink_post_title') . '
					</select>
				</p>';
	
	/**
	 * Hide Post Meta
	 */
	$output .= themify_post_meta_options($prefix.'post_meta', $data);
	
	/**
	 * Hide Post Date
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Post Date', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_date">' .
						themify_options_module($default_options, $prefix.'post_date') . '
					</select>
				</p>';
	
	/**
	 * Auto Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Auto Featured Image', 'themify') . '</span>
					<label for="setting-auto_featured_image"><input type="checkbox" value="1" id="setting-auto_featured_image" name="setting-auto_featured_image" ' . checked( themify_get( 'setting-auto_featured_image' ), 1, false ) . '/> ' . __( 'If no featured image is specified, display first image in content.', 'themify' ) . '</label>
				</p>';
	
	/**
	 * Featured Image/Media Position
	 */
	$output .= '<p>
					<span class="label">' . __( 'Featured Image/Media Position', 'themify' ) . '</span>
					<select name="' . esc_attr( $prefix ) . 'media_position">' .
						themify_options_module( $media_position, $prefix.'media_position' ) . '
					</select>
				</p>';
	
	/**
	 * Hide Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_image">' .
						themify_options_module($default_options, $prefix.'post_image') . '
					</select>
				</p>';
	
	/**
	 * Unlink Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Unlink Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_image">' .
						themify_options_module($default_options, $prefix.'unlink_post_image') . '
					</select>
				</p>';
	
	/**
	 * Featured Image Sizes
	 */
	$output .= themify_feature_image_sizes_select('image_post_feature_size');
	
	/**
	 * Image Dimensions
	 */	
	$output .= '<p class="show_if_enabled_img_php">
                            <span class="label">' . __('Image Size', 'themify') . '</span>  
                            <input type="text" class="width2" name="setting-image_post_width" value="' . themify_get( 'setting-image_post_width' ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>
                            <input type="text" class="width2" name="setting-image_post_height" value="' . themify_get( 'setting-image_post_height' ) . '" /> <span>' . __('height', 'themify') . ' <small>(px)</small></span>
                            <br /><span class="pushlabel"><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
                    </p>';
	
	return $output;
}


if (!function_exists('themify_pagination_infinite')) {

	/**
	 * Choose pagination or infinite scroll
	 * @param array $data
	 * @return string
	 */
	function themify_pagination_infinite($data = array()) {

		$output = '<p><span class="label">' . __( 'Pagination Option', 'themify' ) . '</span>';

		//Infinite Scroll
		$output .= '<input ' . checked( themify_check( 'setting-more_posts' ) ? themify_get( 'setting-more_posts' ) : 'infinite', 'infinite', false ) . ' type="radio" id="setting-more_posts_infinite" name="setting-more_posts" value="infinite" /> ';
		$output .= __('Infinite Scroll (posts are loaded on the same page)', 'themify');
		$output .= '<div class="pushlabel disable-autoinfinite" data-show-if-element="[name=setting-more_posts]:checked" data-show-if-value="infinite">';
		$output .= '<label for="setting-autoinfinite"><input type="checkbox" id="setting-autoinfinite" name="setting-autoinfinite" '.checked( themify_get( 'setting-autoinfinite' ), 'on', false ).'/> ' . __('Disable automatic infinite scroll', 'themify').'</label>';
		$output .= '<br/>';
		$output .= '<label for="setting-infinite-url"><input type="checkbox" id="setting-infinite-url" name="setting-infinite-url" '.checked( themify_get( 'setting-infinite-url' ), 'on', false ).'/> ' . __('Disable page number updates on address URL on scrolling', 'themify').'</label>';
		$output .= '</div>';
		$output .= '<br/>';

		//Numbered pagination
		$output .= '<span class="pushlabel"><input ' . checked( themify_get( 'setting-more_posts' ), 'pagination', false ) . ' type="radio" id="setting-more_posts_pagination" name="setting-more_posts" value="pagination" /> ';
		$output .= __('Standard Pagination', 'themify') . '</span>';
		$output .= '</p>';

		$key = 'setting-entries_nav';
		$output .= '<div class="pushlabel disable-autoinfinite" data-show-if-element="[name=setting-more_posts]:checked" data-show-if-value="pagination">';
		$output .= '<p>';
			// Numbered pagination
			$output .= '<label for="' . esc_attr( $key . '_numbered' ) . '">';
			$output .= '<input ' . checked( isset( $data[$key] )? $data[$key] : 'numbered', 'numbered', false) . ' type="radio" id="' . esc_attr( $key . '_numbered' ) . '" name="' . esc_attr( $key ) . '" value="numbered" /> ';
			$output .= __( 'Numbered Page Navigation (page 1, 2, 3, etc.)', 'themify' ) . '</label>';
			$output .= '<br/>';
			
			// Previous / Next links
			$output .= '<label for="' . esc_attr( $key . '_prevnext' ) . '">';
			$output .= '<input ' . checked( isset( $data[$key] )? $data[$key] : '', 'prevnext', false ) . ' type="radio" id="' . esc_attr( $key . '_prevnext' ) . '" name="' . esc_attr( $key ) . '" value="prevnext" /> ';
			$output .= __( 'Previous Posts and Next Posts Links', 'themify' ) . '</label>';
		$output .= '</p>';
		$output .= '</div>';
		
		return $output;
	
	}

}


if (!function_exists('themify_footer_social_banners')) {

	/**
	 * Choose pagination or infinite scroll
	 * @param array $data
	 * @return string
	 */
	function themify_footer_social_banners($data = array()) {
		
		$socials = themify_get_footer_banners();
		$output = '';
		if(!empty($socials)){
			$key = 'settings-footer_banner_';
			
			foreach($socials as $k=>$v){
				$input = $key.$k;
				$output.= '<p><span class="label">' . $v . '</span><label><input type="checkbox" value="'.$k.'" id="'.$input.'" name="'.$input.'" '.checked( themify_get( $input ),$k, false ).' />'.sprintf(__('Show %s banner','themify'),$v).'</label></p>';
				$output.='<div  class="pushlabel" data-show-if-element="[name='.$input.']" data-show-if-value=' . '["true"]' . '>';
				$input = $key.$k.'_username';
				$output.='<label><input type="text" name="'.$input.'" value="'.esc_attr(themify_get($input)).'">'.__('Username','themify').'</label><br/>';
				$input = $key.$k.'_link';
				$output.='<label><input class="width8" type="text" name="'.$input.'" value="'.esc_url(themify_get($input)).'">'.__('Banner Link','themify').'</label><br/>';
				$input = $key.$k.'_image';
				$output.='<input class="width8"  type="text" id="'.$input.'" name="'.$input.'" value="'.esc_url(themify_get($input)).'">'.__('Banner Image','themify').themify_get_uploader($input, array('tomedia' => true)) .'<br/>';
				$output.='</div>';
			}
		}
		return $output;
	
	}

}
