<?php
/***************************************************************************
 *  					Theme Functions
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 *
 *  					Copyright (C) Themify
 * 						https://themify.me
 *
 *  To add custom PHP functions to the theme, create a child theme (https://themify.me/docs/child-theme) and add it to the child theme functions.php file.
 *  They will be added to the theme automatically.
 *
 ***************************************************************************/

/////// Actions ////////
// Init post, page and additional post types if they exist
add_action( 'after_setup_theme', 'themify_theme_after_setup_theme',15 );



if ( themify_get( 'setting-disable_responsive_design' ) == 'on' ) {
	add_action( 'init', 'themify_disable_responsive_design' );
}


// Register custom menu
add_action( 'init', 'themify_register_custom_nav' );

// Register sidebars
add_action( 'widgets_init', 'themify_theme_register_sidebars' );

// Exclude CPT for sidebar
add_filter( 'themify_exclude_CPT_for_sidebar', 'themify_CPT_exclude_sidebar' );

// Set class on body tag according to layout width
add_filter( 'body_class', 'themify_theme_body_class', 99 );

/////// Filters ////////

/**
 * Enqueue Stylesheets and Scripts
 * @since 1.0.0
 */
function themify_theme_enqueue_scripts() {
	global $themify, $wp_query;
	
	// Get theme version for Themify theme scripts and styles
	$theme_version = wp_get_theme()->display( 'Version' );

	///////////////////
	// Enqueue styles
	///////////////////
	
	$design_preset_dependency = array( 'theme-style' );
	$is_mobile = themify_is_touch('phone');

	// Themify base styling
	wp_enqueue_style( 'theme-style', themify_enque( THEME_URI . '/style.css' ), array(), $theme_version );
	
	$header = themify_theme_get_header_design();

	// Themify Media Queries CSS
	wp_enqueue_style( 'themify-media-queries', themify_enque(THEME_URI . '/media-queries.css'), array(), $theme_version);

	// User stylesheet
	if ( is_file( TEMPLATEPATH . '/custom_style.css' ) ) {
		wp_enqueue_style( 'custom-style', THEME_URI . '/custom_style.css' );
	}
	
	wp_enqueue_script('themify-smartresize', THEME_URI . '/js/jquery.smartresize.min.js', array('jquery'), $theme_version, true);
 
	
	if( themify_is_woocommerce_active() ) {
		
		// Load WooCommerce PrettyPhoto resources to fix image gallery in product lightbox
		if( themify_get_gallery_type() === 'default' ) {
			if( version_compare( WOOCOMMERCE_VERSION, '3.0.0', '>=' ) ) {
				wp_enqueue_script('flexslider');
				wp_enqueue_script('photoswipe-ui-default');
				wp_enqueue_script('zoom');
				wp_enqueue_style('photoswipe-default-skin');
			}
		}
		else{
			wp_dequeue_script( 'flexslider');
			wp_dequeue_script( 'photoswipe-ui-default');
			wp_dequeue_script( 'zoom');
			wp_dequeue_style( 'photoswipe-default-skin');
		}
		//Themify shop stylesheet
		wp_enqueue_style( 'themify-woocommerce', themify_enque(THEME_URI . '/styles/woocommerce.css') );

		$design_preset_dependency[] = 'themify-woocommerce';
		
		if(!themify_check('setting-spark_animation')){			
			//Set ClickSpark events//
			wp_register_script('themify-clickspark', THEME_URI . '/js/clickspark.min.js', array('jquery'), $theme_version, true);

			// if color is not defined in admin area set gold as default
			$sparkling_color = themify_get( 'setting-spark_color' ) ? themify_get( 'setting-spark_color' ) : "#dcaa2e";
			wp_localize_script('themify-clickspark','sparkling_color',$sparkling_color);

			wp_enqueue_script('themify-clickspark');
		}
		
		// Themify shop script
		wp_register_script( 'theme-shop', themify_enque(THEME_URI . '/js/themify.shop.js'), array('jquery'), $theme_version, true );
		
		// Inject variable values in themify.shop.js
		// Can be filtered hooking to themify_shop_js_vars
		wp_localize_script( 'theme-shop', 'themifyShop', apply_filters(
				'themify_shop_js_vars',
				array(
					'themibox' => array(
						'close' => '<a href="#" class="close-lightbox"><i class="icon-flatshop-close"></i></a>',
					),
					'cartUrl' => wc_get_cart_url(),
					'redirect'=> get_option( 'woocommerce_cart_redirect_after_add' ) === 'yes' ? wc_get_cart_url() : false,
					'theme_url' => THEME_URI,
					'wc_variation_url' => str_replace( array( 'http:', 'https:' ), '', WC()->plugin_url() ) . '/assets/js/frontend/add-to-cart-variation.min.js',
					'wc_version' => WC()->version,
					'version' => $theme_version,
					'placeholder' => wc_placeholder_img_src(),
					'variations_text' => array(
						'i18n_no_matching_variations_text' => esc_attr__( 'Sorry, no products matched your selection. Please choose a different combination.', 'woocommerce' ),
						'i18n_make_a_selection_text'       => esc_attr__( 'Please select some product options before adding this product to your cart.', 'woocommerce' ),
						'i18n_unavailable_text'            => esc_attr__( 'Sorry, this product is unavailable. Please choose a different combination.', 'woocommerce' ),
					)
				)
			)
		);
	
		wp_enqueue_script('theme-shop');
		// Variation scripts
		if( is_shop() ) {
			themify_get_gallery_type() === 'default' && wp_enqueue_script( 'wc-single-product' );
		}
	}
	
	if( $header != '' && $header != 'default' && $header != 'header-none'  && $header != 'header-logo-center'  ) {
		wp_enqueue_style( $header, themify_enque(THEME_URI . '/styles/' . $header . '.css'), $design_preset_dependency );
	}

	// Themify child base styling
	if( is_child_theme() ) {
		wp_enqueue_style( 'theme-style-child', themify_enque( get_stylesheet_uri() ), array(), $theme_version );
	}

	///////////////////
	// Enqueue scripts
	///////////////////
	
	wp_enqueue_script( 'imagesloaded');
	
	// Slide mobile navigation menu
	wp_enqueue_script( 'slide-nav', THEMIFY_URI . '/js/themify.sidemenu.min.js', array( 'jquery' ), THEMIFY_VERSION, true );

	// Themify internal scripts
	wp_register_script( 'theme-script',	themify_enque(THEME_URI . '/js/themify.script.js'), array( 'jquery' ), $theme_version, true );
	
	// Prepare JS variables
	$themify_script_vars = array(
		'lightbox' => themify_lightbox_vars_init(),
		'lightboxContext' => apply_filters( 'themify_lightbox_context', '#pagewrap' ),
		'ajax_url' => admin_url( 'admin-ajax.php' ),
		'theme_url'=>THEME_URI,
		'sticky_header'=>themify_theme_sticky_logo(),
		'menuInSidePanel' => false,
		'events' => $is_mobile || themify_is_touch() ? 'click' : 'mouseenter',
		'loadingImg'   	=> THEME_URI . '/images/loading.gif',
		'maxPages'	   	=> $wp_query->max_num_pages,
		'autoInfinite' 	=> themify_check( 'setting-autoinfinite' ) ? 'no': 'auto',
		'infiniteURL' => themify_check( 'setting-infinite-url' ) ? 1 : 0,
		'ajaxCartSeconds' => themify_check( 'setting-cart_show_seconds' ) ? themify_get( 'setting-cart_show_seconds' ) : 1000,
		'ajaxSingleCart' => is_singular( 'product' ) && themify_check( 'setting-single_ajax_cart' ),
		 // auto tiles
		'tiledata' => array(
			'grids' => array(
				"post" => $is_mobile?false:themify_set_tiles_template(),
				"mobile" => array("AA", "..")
			),
			'default_grid' => 'post',
			'small_screen_grid' => 'mobile',
			'breakpoint' => 800,
			'padding' => 5,
			'full_width' => false,
			'animate_init' => false,
			'animate_resize' => true,
			'animate_template' => false
		)
	);
	
	// Pass variable values to JavaScript
	wp_localize_script( 'theme-script', 'themifyScript', apply_filters( 'themify_script_vars', $themify_script_vars ) );
	
	wp_enqueue_script('theme-script');

	// WordPress internal script to move the comment box to the right place when replying to a user
	if ( is_single() || is_page() ) wp_enqueue_script( 'comment-reply' );
}

/**
 * Load Google fonts used by the theme
 *
 * @return array
 */
function themify_theme_google_fonts( $fonts ) {
	/* translators: If there are characters in your language that are not supported by Libre Franklin, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Libre Franklin font: on or off', 'themify' ) ) {
		$fonts['libre-franklin'] = 'Libre+Franklin:400,300,500,600,700';
	}

	return $fonts;
}
add_filter( 'themify_google_fonts', 'themify_theme_google_fonts' );

function themify_theme_dequeue_scripts(){
	wp_dequeue_style( 'themify-icon-font');
	wp_dequeue_script('themify-mega-menu');
}

if (is_admin()) {
    add_action('admin_enqueue_scripts', 'themify_admin_script_style');

    function themify_admin_script_style() {
        wp_enqueue_script('themify-admin-script', themify_enque(THEME_URI . '/admin/js/admin-script.js'));
    }

}
else{
	// Enqueue scripts and styles required by theme
	add_action( 'wp_enqueue_scripts', 'themify_theme_enqueue_scripts', 11 );
        add_filter('themify_main_script_vars','themify_add_minify_vars',10,1);
	add_action( 'wp_enqueue_scripts', 'themify_theme_dequeue_scripts', 15 );
	// Browser compatibility
	add_action( 'wp_head', 'themify_viewport_tag' );
}

function themify_add_minify_vars($vars){
    $vars['minify']['js']['themify-tiles'] = themify_enque(THEME_URI.'/js/themify-tiles.js',true);
    $vars['minify']['js']['themify.wishlist'] = themify_enque(THEME_URI.'/js/themify.wishlist.js',true);
    $vars['minify']['js']['themibox'] = themify_enque(THEME_URI.'/js/themibox.js',true);
    return $vars;
}
/**
 * Logic for fixed header. Checks, if it applies, custom fields first and then theme settings.
 *
 * @since 1.0.0
 *
 * @return string
 */
function themify_theme_fixed_header() {
	static $header_fixed = null;
	if(is_null($header_fixed)){
		$header = themify_area_design( 'header', array(
		'values'  => wp_list_pluck( themify_theme_header_design_options(), 'value' ), ) );
		if ( in_array( $header, array( 'none', 'header-boxed-content', 'header-left-pane', 'header-right-pane', 'header-minbar-left', 'header-minbar-right' ) ) ) {
			$header_fixed = 'no-fixed-header';
		}
		elseif ( is_singular( array( 'post', 'page', 'product' ) ) ) {
			$fixed_header_field = themify_get( 'fixed_header' );
			$header_fixed = 'yes' == $fixed_header_field ?'fixed-header':($fixed_header_field==='no'?'no-fixed-header':'');
		}
		if(!$header_fixed){
			$header_fixed = themify_check( 'setting-fixed_header_disabled' ) ? 'no-fixed-header' : 'fixed-header';
		
		}
	}
	
	return $header_fixed;
}

if ( ! function_exists( 'themify_theme_body_class' ) ) {
	/**
	 * Adds body classes for special theme features.
	 *
	 * @since 1.0.0
	 *
	 * @param $classes
	 *
	 * @return array
	 */
	function themify_theme_body_class( $classes ) {
		
		$header = themify_theme_get_header_design();
		if($header!=='default'){
			$classes[] = $header;
		}
		$classes[] = themify_theme_fixed_header();
		if(themify_is_woocommerce_active()){
                    $classes[] = 'cart-style-'.themify_get_cart_style();
                    if(sizeof(WC()->cart->get_cart())===0){
                            $classes[] = 'wc-cart-empty';
                    }
		}
		if ( ! in_array( $header, array( 'header-left-pane', 'header-right-pane', 'header-minbar', 'header-none' ) ) ) {
			// Add transparent-header class to body if user selected it in custom panel
			if ( ( is_single() || is_page() ) && 'transparent' == themify_get( 'header_wrap' ) ) {
				$classes[] = 'transparent-header';
			}
		}
		if ( 'header-block' == $header && 'yes' == themify_theme_get( 'full_height_header' ) ) {
			$classes[] = 'header-full-height';
		}

		// Footer Design
		$footer = themify_area_design( 'footer', array(
			'default' => '',
			'values'  => wp_list_pluck( themify_theme_footer_design_options(), 'value' ),
		) );
		$classes[] = 'none' == $footer ? 'footer-none' : $footer;


		// Exclusion classes
		if ( ! themify_theme_show_area( 'site_logo' ) ) {
			$classes[] = 'logo-off';
		}
		if ( ! themify_theme_show_area( 'site_tagline' ) ) {
			$classes[] = 'tagline-off';
		}
		if ( ! themify_theme_show_area( 'search_form' ) ) {
			$classes[] = 'search-off';
		}
		if ( ! themify_theme_show_area( 'menu_navigation' ) ) {
			$classes[] = 'menu-navigation-off';
		}
		if ( ! themify_theme_show_area( 'wishlist' ) ) {
			$classes[] = 'wishlist-icon-off';
		}
		if ( ! themify_theme_show_area( 'cart' ) ) {
			$classes[] = 'cart-icon-off';
		}
		if ( ! themify_theme_show_area( 'top_bar_widgets' ) ) {
			$classes[] = 'top-bar-widgets-off';
		}
		if ( ! themify_theme_show_area( 'footer' ) ) {
			$classes[] = 'footer-off';
		}
		if ( ! themify_theme_show_area( 'footer_widgets' ) ) {
			$classes[] = 'footer-widgets-off';
		}
		if ( ! themify_theme_show_area( 'footer_menu_navigation' ) ) {
			$classes[] = 'footer-menu-navigation-off';
		}
				
		// Image Filters
		$filter = '';
		$filter_hover = '';
		$apply_to = '';
		global $themify;
		if ( is_page() ) {

			if ( $do_filter = themify_get( 'imagefilter_options' ) ) {
				if ( 'initial' != $do_filter ) {
					$filter = 'filter-' . $do_filter;
				}
			}

			if ( $do_hover_filter = themify_get( 'imagefilter_options_hover' ) ) {
				if ( 'initial' != $do_hover_filter ) {
					$filter_hover = 'filter-hover-' . $do_hover_filter;
				}
			}

			if ( $apply_here = themify_get('imagefilter_applyto') ) {
				if ( 'initial' != $apply_here ) {
					$apply_to = 'filter-' . $apply_here;
				}
			}

		} elseif ( is_singular() ) {

			if ( $do_filter = themify_get( 'imagefilter_options' ) ) {
				if ( 'initial' != $do_filter ) {
					$filter = 'filter-' . $do_filter;
				}
			}

			if ( $do_hover_filter = themify_get( 'imagefilter_options_hover' ) ) {
				if ( 'initial' != $do_hover_filter ) {
					$filter_hover = 'filter-hover-' . $do_hover_filter;
				}
			}

			if ( $apply_here = themify_get('imagefilter_applyto') ) {
				if ( 'initial' != $apply_here ) {
					$apply_to = 'filter-' . $apply_here;
				}
			}
			if(is_singular('product')){
				$classes[] = 'product-'.themify_theme_get('image_layout');
			}
			
		}

		if ( '' == $filter ) {
			if ( $do_filter = themify_get( 'setting-imagefilter_options' ) ) {
				$filter = 'filter-' . $do_filter;
			}
		}

		if ( '' == $filter_hover ) {
			if ( $do_hover_filter = themify_get( 'setting-imagefilter_options_hover' ) ) {
				$filter_hover = 'filter-hover-' . $do_hover_filter;
			} else {
				$filter_hover = 'filter-hover-none';
			}
		}

		if ( '' == $apply_to ) {
			if ( '' != $filter || '' != $filter_hover ) {
				if ( 'allimages' == themify_get('setting-imagefilter_applyto') ) {
					$apply_to = 'filter-all';
				} else {
					$apply_to = 'filter-featured-only';
				}
			}
		}
		$classes[] = themify_is_touch('phone') ? 'is_phone' : 'tile_enable';
		
		$classes[] = $themify->layout;
		$classes[] = $filter;
		$classes[] = $filter_hover;
		$classes[] = $apply_to;
		;
		if(($post_layout = array_search('auto_tiles',$classes))!==false){
			unset($classes[$post_layout]);
		}

		if( themify_check( 'setting-revealing_footer' ) ) {
			$classes[] = 'revealing-footer';
		}

		return $classes;
	}
}

/**
 * Checks if .animated-bg class must be output and sets the first animation color as initial background
 * Displays the data-bg and class attributes, including the background image and fullcover class
 *
 * @since 1.0.0
 *
 * @param string $area
 * @param string $classes Additional CSS classes to output for this element
 */
function themify_theme_header_background( $area = 'header', $classes = '' ) {
	$class = '';
	$style = '';
	$image = null;
	$repeat = '';
	$data_bg = '';
	$post_id = get_the_ID();
	$nobg = '';
	$area_wrap = themify_get( $area . '_wrap' );
	$image_meta = '';
	$background_gallery = '';

	if ( 'header' === $area && in_array( $area_wrap, array( 'video', 'slider' ) ) ) {
		$back_key = 'styling-background-header_wrap_background-background_image-value-value';
		$mode_key = 'styling-background-header_wrap_background-background_mode-value-value';
		$nobg_key = 'styling-background-header_wrap_background-background_image-value-none';
		$header_customizer = json_decode( get_theme_mod( 'headerwrap_background' ) );

		if ( isset( $header_customizer->src ) && '' != $header_customizer->src ) {
			$image = $header_customizer->src;
			$repeat = isset( $header_customizer->style ) ? $header_customizer->style : 'fullcover';
		} elseif ( themify_check( $back_key ) ) {
			$image = themify_get( $back_key );
			$repeat = themify_check( $mode_key )? themify_get( $mode_key ): 'fullcover';
		}
		$nobg = themify_get( $nobg_key ) || ( isset( $header_customizer->noimage ) && 'noimage' == $header_customizer->noimage );

		if ( is_page() || is_singular( 'post' ) || is_singular( 'portfolio' ) ) {
			global $themify;

			if ( is_page() ) {
				$post_id = $themify->page_id;
			} else {
				$post_id = get_the_ID();
			}

			$image_meta = get_post_meta($post_id, 'background_image', true);
			if ( $image_meta ) {
				$image = $image_meta;
				$repeat_meta = get_post_meta($post_id, 'background_repeat', true);
				if ( $repeat_meta ) {
					$repeat = $repeat_meta;
				}
			}
			$background_color = get_post_meta( $post_id, 'background_color', true );
			if ( $area_wrap == 'slider' && $background_color != '' ) {
				$data_bg .= "data-bgcolor='$background_color'";
			}
			$background_gallery = get_post_meta( $post_id, 'background_gallery', true );
			if ( $gallery = ( ( $area_wrap == 'slider' ) || ( $area_wrap == '' && $background_gallery != '' ) ) ) {
				$repeat = 'fullcover header-gallery';
			} elseif ( $nobg ) {
				// Checks $image_meta because $image might have been set in customizer and we don't need to check that.
				if ( is_singular() && $image_meta ) {
					$data_bg .= " data-bg='$image'";
				}
			} elseif ( $image ) {
				$data_bg .= " data-bg='$image'";
			} else {
				$data_bg .= ' data-bg="https://themify.me/demo/themes/wp-content/uploads/2013/05/header.jpg"';
				$repeat = 'fullcover';
			}

			$video = get_post_meta( $post_id, 'video_file', true );

			if ( 'video' == $area_wrap && $video != '' ) {
				$data_bg .= " data-fullwidthvideo='$video'";
				if ( ! wp_script_is( 'themify-bigvideo-js' ) ) {
					wp_enqueue_script( 'themify-bigvideo-js' );
				}
			}
		}
	}

	if ( $repeat || $classes ) {
		$class = "class='$repeat $classes'";
	}

	if ( !empty( $style ) ) {
		$style = 'style="' . $style . '"';
	}

	echo "$data_bg $class $style";
}

/**
 * Function that checks if meta data exists and retrieves it, otherwise checks theme setting and retrieves it instead.
 * If it still doesn't exist, uses the default provided.
 *
 * @since 1.0.0
 *
 * @param string $meta
 * @param string $default
 * @param string $theme_setting
 *
 * @return mixed
 */
function themify_theme_get( $meta, $default = '', $theme_setting = '' ) {
	global $themify;
	$post_type = '';

	// If it's a singular view or a query page, try to get the post meta data first
	if ( themify_is_query_page() ) {
		if ( '' != $themify->query_post_type && 'post' != $themify->query_post_type ) {
			$post_type = $themify->query_post_type . '_';
			$cpt_meta = $post_type . $meta;
		} 
		else{
			$cpt_meta = $meta;
		}
		
		$value = get_post_meta( $themify->page_id, $cpt_meta, true );
		
		if ($value==='0' || ('' != $value && 'default' != $value )) {
			return $value;
		}

	} elseif ( is_singular() ) {
		// Check first without checking for custom post type
		$value = get_post_meta( get_the_ID(), $meta, true );

		if ($value==='0' || ('' != $value && 'default' != $value )) {
			return $value;
		}
		// Let's check now prefixing with post type
		if ( ( 'post' != get_post_type() && 'page' != get_post_type() ) ) {
			$post_type = get_post_type() . '_';
		}
		$cpt_meta = $post_type . $meta;
		$value = get_post_meta( get_the_ID(), $cpt_meta, true );
		if ($value==='0' || ('' != $value && 'default' != $value )) {
			return $value;
		}
	}

	// If there is no post meta data or is '' (default), prepare to fetch theme setting
	if ( empty( $theme_setting ) ) {
		if ( themify_is_query_page() && '' != $themify->query_post_type && 'post' != $themify->query_post_type ) {
			$post_type = $themify->query_post_type . '_';
		} elseif ( is_singular() && ( 'post' != get_post_type() && 'page' != get_post_type() ) ) {
			$post_type = get_post_type() . '_';
		}
		$theme_setting = 'setting-' . $post_type . $meta;
	}

	// Check theme setting (if there's a special setting like for portfolios it will be checked)
	if ( themify_check( $theme_setting ) ) {
		return themify_get( $theme_setting );
	}

	// Prepare to check non special setting stripping out the post type from setting key
	if ( 'post' != $post_type ) {
		$theme_setting = str_replace( $post_type, '', $theme_setting );
	}
	// Check regular setting (like portfolios that rely in default layouts setting)
	if ( themify_check( $theme_setting ) ) {
		return themify_get( $theme_setting );
	}
	// No luck so return default
	return $default;
}

if ( ! function_exists( 'themify_theme_show_area' ) ) {
	/**
	 * Checks whether to show a certain layout area or not.
	 *
	 * @param string $area
	 *
	 * @return bool
	 */
	function themify_theme_show_area( $area = '' ) {
		$show = true;
		switch ( $area ) {
			case 'header':
				$show = 'none' == themify_area_design( $area, array( 'values'  => wp_list_pluck( themify_theme_header_design_options(), 'value' ) ) ) ? false : true;
				break;
			case 'footer':
				$show = 'none' == themify_area_design( $area, array( 'values'  => wp_list_pluck( themify_theme_footer_design_options(), 'value' ) ) ) ? false : true;
				break;
			default:
				if ( is_singular() && ! is_attachment() ) {
					$exclude = themify_get( 'exclude_' . $area );
					if ( 'yes' == $exclude ) {
						$show = false;
					} elseif ( 'no' == $exclude ) {
						$show = true;
					} else {
						$show = themify_check( 'setting-exclude_' . $area ) ? false : true;
					}
				} elseif ( themify_check( 'setting-exclude_' . $area ) ) {
					$show = false;
				}
				break;
		}

		return apply_filters( "themify_theme_show_{$area}", $show );
	}
}

// Load Themify Mega Menu
add_theme_support( 'themify-mega-menu' );

if ( themify_is_woocommerce_active() ) {
	// Load Themify Wishlist
	require_once 'class-wishlist.php';
}

if ( ! function_exists( 'themify_theme_do_not_exclude_all' ) ) {
	/**
	 * Checks if all the elements in a certain area have been excluded.
	 *
	 * @since 1.0.0
	 *
	 * @param string $area
	 *
	 * @return bool
	 */
	function themify_theme_do_not_exclude_all( $area = 'header' ) {
		if ( 'mobile-menu' == $area ) {
			return themify_theme_show_area( 'search_icon' ) || themify_theme_show_area( 'top_bar_widgets' ) || themify_theme_show_area( 'menu_navigation' );
		} elseif ( 'header' == $area ) {
			return themify_theme_show_area( 'site_logo' ) || themify_theme_show_area( 'site_tagline' ) || themify_theme_show_area( 'search_icon' ) || themify_theme_show_area( 'top_bar_widgets' ) || themify_theme_show_area( 'menu_navigation' );
		} elseif ( 'footer' == $area ) {
			return themify_theme_show_area( 'footer_site_logo' ) || themify_theme_show_area( 'footer_menu_navigation' ) || themify_theme_show_area( 'footer_texts' ) || themify_theme_show_area( 'footer_widgets' ) || themify_theme_show_area( 'footer_back' );
		}
		return false;
	}
}

/**
 * Add viewport tag for responsive layouts
 * @since 1.0.0
 */
function themify_viewport_tag() {
	echo "\n".'<meta name="viewport" content="width=device-width, initial-scale=1">'."\n";
}

if ( ! function_exists( 'themify_theme_after_setup_theme' ) ) {
	/**
	 * Register theme support.
	 *
	 * Initialize custom panel with its definitions.
	 * Custom panel definitions are located in admin/post-type-TYPE.php
	 *
	 * @since 1.0.7
	 */
	function themify_theme_after_setup_theme() {
		// Load Themify Social Share
		require_once 'class-social-share.php';
		
		// Load required files for post, page and custom post types where it applies
		foreach ( array( 'post', 'page','product','portfolio') as $type ) {
			require_once( "admin/post-type-$type.php" );
		}
		/**
		 * Navigation menus used in page custom panel to specify a custom menu for the page.
		 * @since 1.0.0
		 * @var array
		 */
		$nav_menus = array(	array( 'name' => '', 'value' => '', 'selected' => true ) );
		foreach ( get_terms( 'nav_menu' ) as $menu ) {
			$nav_menus[] = array( 'name' => $menu->name, 'value' => $menu->slug );
		}

		/**
		 * Options for header design
		 * @since 1.0.0
		 * @var array
		 */
		$header_design_options = themify_theme_header_design_options();

		/**
		 * Options for footer design
		 * @since 1.0.0
		 * @var array
		 */
		$footer_design_options = themify_theme_footer_design_options();


		$entry_id = isset( $_GET['post'] ) ? $_GET['post'] : null;
		$background_slider = false;
		if ( $entry_id ) {
			$background_slider = ( get_post_meta( $entry_id, 'header_wrap', true ) == '' && get_post_meta( $entry_id, 'background_gallery', true ) != '' );
			$background_mode = get_post_meta( $entry_id,'background_mode', true );
		}
		if ( ! isset( $background_mode ) || ! $background_mode ) {
			$background_mode = 'fullcover';
		}

		themify_build_write_panels( apply_filters( 'themify_theme_meta_boxes', array(
			array(
				'name'    => __( 'Post Options', 'themify' ),
				'id'      => 'post-options',
				'options' => themify_theme_post_meta_box( array(
					'nav_menus' => $nav_menus,
				) ),
				'pages'   => 'post'
			),
			array(
				'name'    => __( 'Page Appearance', 'themify' ),
				'id'      => 'post-theme-design',
				'options' => themify_theme_page_theme_design_meta_box( array(
					'header_design_options' => $header_design_options,
					'footer_design_options' => $footer_design_options,
					'background_slider'		=> $background_slider,
					'background_mode'		=> $background_mode,
				) ),
				'pages'   => 'post'
			),
			array(
				'name'    => __( 'Page Options', 'themify' ),
				'id'      => 'page-options',
				'options' => themify_theme_page_meta_box( array(
					'nav_menus' => $nav_menus,
					'header_design_options' => $header_design_options,
					'footer_design_options' => $footer_design_options,
				) ),
				'pages'   => 'page'
			),
			array(
				'name'    => __( 'Page Appearance', 'themify' ),
				'id'      => 'page-theme-design',
				'options' => themify_theme_page_theme_design_meta_box( array(
					'header_design_options' => $header_design_options,
					'footer_design_options' => $footer_design_options,
					'background_slider'		=> $background_slider,
					'background_mode'		=> $background_mode,
				) ),
				'pages'   => 'page'
			),
			array(
				'name'    => __( 'Query Posts', 'themify' ),
				'id'      => 'query-posts',
				'options' => themify_theme_query_post_meta_box(),
				'pages'   => 'page'
			),
			array(
				'name'    => __( 'Query Products', 'themify' ),
				'id'      => 'query-products',
				'options' => themify_theme_query_product_meta_box(),
				'pages'   => 'page'
			),
			array(
				'name'    => __( 'Product Options', 'themify' ),
				'id'      => 'product-options',
				'options' => themify_theme_product_meta_box(),
				'pages'   => 'product'
			),
			array(
				'name'    => __( 'Page Appearance', 'themify' ),
				'id'      => 'product-theme-design',
				'options' => themify_theme_page_theme_design_meta_box( array(
					'header_design_options' => $header_design_options,
					'footer_design_options' => $footer_design_options,
					'background_slider'		=> $background_slider,
					'background_mode'		=> $background_mode,
				) ),
				'pages'   => 'product'
			),
		)));
        }
}

///////////////////////////////////////
// Enable WordPress feature image
///////////////////////////////////////
add_theme_support( 'post-thumbnails' );

if ( ! function_exists( 'themify_register_custom_nav' ) ) {
	/**
	 * Register Custom Menu Function
	 * @since 1.0.0
	 */
	function themify_register_custom_nav() {
		register_nav_menus( array(
			'main-nav' => __( 'Main Navigation', 'themify' ),
			'icon-menu'=>__('Icon Navigation','themify'),
			'footer-nav' => __( 'Footer Navigation', 'themify' )
		));
	}
}

if ( ! function_exists( 'themify_default_main_nav' ) ) {
	/**
	 * Default Main Nav Function
	 * @since 1.0.0
	 */
	function themify_default_main_nav() {
		echo '<ul id="main-nav" class="main-nav clearfix">';
			wp_list_pages( 'title_li=' );
		echo '</ul>';
	}
}

if ( ! function_exists( 'themify_theme_menu_nav' ) ) {
	/**
	 * Sets custom menu selected in page custom panel as navigation, otherwise sets the default.
	 *
	 * @since 1.0.0
	 */
	function themify_theme_menu_nav() {
		$args = array(
			'theme_location' => 'main-nav',
			'fallback_cb'    => 'themify_default_main_nav',
			'container'      => '',
			'menu_id'        => 'main-nav',
			'menu_class'     => 'main-nav'
		);
		// Get entry ID reliably
		$queried_object = get_queried_object();
		$entry_id = isset( $queried_object->ID ) ? $queried_object->ID : 0;

		// Compile menu arguments
		$args = wp_parse_args( $args, array(
			'theme_location' => 'main-nav',
			'fallback_cb' => 'themify_default_main_nav',
			'container'   => '',
			'menu_id'     => 'main-nav',
			'menu_class'  => 'main-nav'
		));
		$args['walker'] = new Themify_Mega_Menu_Walker;

		// See if the page has a menu assigned
		$custom_menu = get_post_meta( $entry_id, 'custom_menu', true );
		if ( ! empty( $custom_menu ) ) {
			$args['menu'] = $custom_menu;
		}

		// Render the menu
		wp_nav_menu( $args );
	}
}

if ( ! function_exists( 'themify_theme_register_sidebars' ) ) {
	/**
	 * Register sidebars
	 * @since 1.0.0
	 */
	function themify_theme_register_sidebars() {
		$sidebars = array(
			array(
				'name' => __( 'Sidebar', 'themify' ),
				'id' => 'sidebar-main',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h4 class="widgettitle">',
				'after_title' => '</h4>',
			),
			array(
				'name' => __('Below Footer Logo Widget', 'themify'),
				'id' => 'below-logo-widget',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<strong class="widgettitle">',
				'after_title' => '</strong>',
			),
			array(
				'name' => __( 'Top Bar Left', 'themify' ),
				'id' => 'top-bar-left',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h4 class="widgettitle">',
				'after_title' => '</h4>',
			),
			array(
				'name' => __( 'Top Bar Right', 'themify' ),
				'id' => 'top-bar-right',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h4 class="widgettitle">',
				'after_title' => '</h4>',
			)
		);
		if(!themify_get('setting-disable_shop_sidebar')){
			$sidebars[] = array(
							'name' => __( 'Shop Sidebar', 'themify' ),
							'id' => 'sidebar-shop',
							'description'=>__('This sidebar will show in WooCommerce pages only.','themify'),
							'before_widget' => '<div id="%1$s" class="widget %2$s">',
							'after_widget' => '</div>',
							'before_title' => '<h4 class="widgettitle">',
							'after_title' => '</h4>',
						);
		}
		foreach( $sidebars as $sidebar ) {
			register_sidebar( $sidebar );
		}
		
		// Footer Sidebars
		themify_register_grouped_widgets();
	}
}

if ( ! function_exists( 'themify_get_sidebar' ) ) {
	function themify_get_sidebar(){
		static $sidebar = null;
		if(is_null($sidebar)){
			$is_wc_active = themify_is_woocommerce_active();
			$sidebar = '';
			if(is_page()){
                            $sidebar = themify_get('sidebar_type');
                            if($sidebar){
                                if(!$is_wc_active && $sidebar==='shop'){
                                    $sidebar = 'main';
                                }
                                $sidebar = 'sidebar-'.$sidebar;
                            }
			}
			if(!$sidebar){
                            $sidebar = $is_wc_active && (is_woocommerce() || is_cart() || is_checkout() || is_wc_endpoint_url() || is_account_page()) && !themify_get('setting-disable_shop_sidebar')?'sidebar-shop':'sidebar-main';
			}
		}
		return $sidebar;
	}

}

if ( ! function_exists( '_wp_render_title_tag' ) ) {
	/**
	 * Fallback to render title before WP 4.1
	 *
	 * @since 1.0.0
	 */
	function themify_theme_render_title() { ?>
		<title><?php wp_title(); ?></title>
	<?php
	}
	// Fallback WP Title
	add_action( 'wp_head', 'themify_theme_render_title' );
} else {
	// Add Title Tag support
	add_theme_support( 'title-tag' );
	/**
	 * Remove last part of title to keep the traditional Themify theme title.
	 *
	 * @since 1.0.0
	 *
	 * @param string $title
	 *
	 * @return string
	 */
	function themify_theme_title_tag( $title ) {
		if ( ! is_front_page() ) {
			$title = str_replace( get_bloginfo( 'name' ), '', $title );
		}
		return $title;
	}
	// Generate title
	add_filter( 'wp_title', 'themify_theme_title_tag', 10 );
}

/**
 * Returns options for header design. Used in custom panel and theme settings.
 *
 * @since 1.0.0
 *
 * @return array List of header design options.
 */
function themify_theme_header_design_options() {
	return apply_filters( 'themify_theme_header_design_options', array(
		
		array(
			'value' => 'default',
			'img'   => 'images/layout-icons/default.png',
			'title' => __( 'Default', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'header-logo-center',
			'img'   => 'images/layout-icons/header-logo-center.png',
			'title' => __( 'Header Logo Center', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'header-logo-left', 
			'img'   => 'images/layout-icons/header-logo-left.png',
			'title' => __( 'Header Logo Left', 'themify' ),
		),
		array(
			'value' => 'header-block',
			'img'   => 'images/layout-icons/header-block.png',
			'title' => __( 'Header Block', 'themify' ),
		),
		array(
			'value' => 'header-boxed-layout',
			'img'   => 'images/layout-icons/header-boxed-layout.png',
			'title' => __( 'Header Boxed Layout', 'themify' ),
		),
		array(
			'value' => 'header-left-pane', 
			'img'   => 'images/layout-icons/header-leftpanel.png',
			'title' => __( 'Header Left Pane', 'themify' ),
		),
		array(
			'value' => 'header-right-pane', 
			'img'   => 'images/layout-icons/header-rightpanel.png',
			'title' => __( 'Header Right Pane ', 'themify' ),
		),
		array(
			'value' => 'header-minbar-left', 
			'img'   => 'images/layout-icons/header-minbar-left.png',
			'title' => __( 'Header Min Bar Left', 'themify' ),
		),
		array(
			'value' => 'header-minbar-right', 
			'img'   => 'images/layout-icons/header-minbar-right.png',
			'title' => __( 'Header Min Bar Right', 'themify' ),
		),
		array(
			'value' => 'header-overlay', 
			'img'   => 'images/layout-icons/header-overlay.png',
			'title' => __( 'Header Overlay ', 'themify' ),
		),
		array(
			'value' => 'header-slide-left', 
			'img'   => 'images/layout-icons/header-slide-left.png',
			'title' => __( 'Header Slide Left', 'themify' ),
		),
		array(
			'value' => 'header-slide-right', 
			'img'   => 'images/layout-icons/header-slide-right.png',
			'title' => __( 'Header Slide Right', 'themify' ),
		),
		array(
			'value' => 'header-stripe',
			'img'   => 'images/layout-icons/header-stripe.png',
			'title' => __( 'Header Stripe', 'themify' ),
		),
		array(
			'value' => 'header-boxed-content', 
			'img'   => 'images/layout-icons/header-boxed-content.png',
			'title' => __( 'Header Boxed Content', 'themify' ),
		),
		array(
			'value' => 'header-bottom',
			'img'   => 'images/layout-icons/header-bottom.png',
			'title' => __( 'Header Bottom', 'themify' ),
		),
		array(
			'value' => 'none', 
			'img'   => 'images/layout-icons/none.png',
			'title' => __( 'No Header ', 'themify' ),
		)
	));
}

/**
 * Returns options for footer design. Used in custom panel and theme settings.
 *
 * @since 1.0.0
 *
 * @return array List of footer design options.
 */
function themify_theme_footer_design_options() {
	return apply_filters( 'themify_theme_footer_design_options', array(
		array(
			'value' => 'default',
			'img'   => 'images/layout-icons/default.png',
			'title' => __( 'Theme Default', 'themify' ),
			'selected' => true,
		),
		array(
			'value' => 'footer-block',
			'img'   => 'images/layout-icons/footer-block.png',
			'title' => __( 'Footer Block', 'themify' ),
		),
		array(
			'value' => 'footer-left-column',
			'img'   => 'images/layout-icons/footer-left-column.png',
			'title' => __( 'Footer Left Column', 'themify' ),
		),
		array(
			'value' => 'footer-right-column',
			'img'   => 'images/layout-icons/footer-right-column.png',
			'title' => __( 'Footer Right Column', 'themify' ),
		),
		array(
			'value' => 'footer-horizontal-left',
			'img'   => 'images/layout-icons/footer-horizontal-left.png',
			'title' => __( 'Footer Horizontal Left', 'themify' ),
		),
		array(
			'value' => 'footer-horizontal-right',
			'img'   => 'images/layout-icons/footer-horizontal-right.png',
			'title' => __( 'Footer Horizontal Right', 'themify' ),
		),
		array(
			'value' => 'none',
			'img'   => 'images/layout-icons/none.png',
			'title' => __( 'No Footer ', 'themify' ),
		)
	)); // default, footer-left-col, footer-right-col, footer-horizontal-left, footer-horizontal-right
}

function themify_theme_get_header_design() {
        static $header = null;
        if(is_null($header)){
            $header = themify_area_design( 'header', array(
                    'default' => '',
                    'values'  => wp_list_pluck( themify_theme_header_design_options(), 'value' ),
            ) );
            $header = 'none' === $header ? 'header-none' : $header;
        }
	return $header;
}

if( ! function_exists('themify_CPT_exclude_sidebar') ) {
	/**
	 * Exclude Custom Post Types
	 */
	function themify_CPT_exclude_sidebar($CPT = array()) {
		
		$shoppe = array('slider');
		
		if(empty($CPT)){
			$CPT = array('post', 'page', 'attachment', 'tbuilder_layout', 'tbuilder_layout_part', 'section');
		}
		
		if(themify_is_woocommerce_active()){
			$shoppe[] = 'product';
		}

		$CPT = array_merge($CPT, $shoppe);

		return $CPT;
	}
}

if ( ! function_exists( 'themify_theme_comment' ) ) {
	/**
	 * Custom Theme Comment
	 *
	 * @since 1.0.0
	 *
	 * @param object $comment Current comment.
	 * @param array $args Parameters for comment reply link.
	 * @param int $depth Maximum comment nesting depth.
	 */
	function themify_theme_comment($comment, $args, $depth) {
	   $GLOBALS['comment'] = $comment; ?>

		<li id="comment-<?php comment_ID() ?>">
			<p class="comment-author">
				<?php echo get_avatar( $comment, $size = '85' ); ?>
				<cite <?php comment_class(); ?>><span <?php comment_class(); ?>><?php echo get_comment_author_link(); ?></span></cite>
				<br />
				<small class="comment-time">
					<?php comment_date( apply_filters( 'themify_comment_date', '' ) ); ?>
					 @
					<?php comment_time( apply_filters( 'themify_comment_time', '' ) ); ?>
					<?php edit_comment_link( __( 'Edit', 'themify' ),' [',']' ); ?>
				</small>
			</p>
			<div class="commententry">
				<?php if ($comment->comment_approved == '0' ) : ?>
					<p><em><?php _e( 'Your comment is awaiting moderation.', 'themify' ) ?></em></p>
				<?php endif; ?>
				<?php comment_text(); ?>
			</div>
			<p class="reply">
				<?php comment_reply_link(array_merge( $args, array( 'add_below' => 'comment', 'depth' => $depth, 'reply_text' => __( 'Reply', 'themify' ), 'max_depth' => $args['max_depth']))) ?>
			</p>
		<?php
	}
}

if ( ! function_exists( 'themify_theme_custom_post_css' ) ) {
	/**
	 * Outputs custom post CSS in the head
	 * @since 1.0.0
	 */
	function themify_theme_custom_post_css() {
		global $themify;

		$style = '';
		$css = array();
		$rules = array();
		$post_id = get_the_ID();
		$post_type = get_post_type( $post_id );
		$header_type = themify_get( 'header_wrap' );

		if ( ! isset( $themify->google_fonts ) ) $themify->google_fonts = '';
		
		switch( $post_type ) {
			case 'product':
				$id = '.post-' . $post_id;
				$product_id = '#product-' . $post_id;
				if ( is_singular( 'product' ) ) {
					$id .= ' .product-single-top';
					$pid = '.single ' . $id;
					$product_id = '.single ' . $product_id;
				}
				else {
					$pid = $id;
					if ( 'list-post' != $themify->post_layout )
						$id .= ' .product-bg';
					else
						$id = '.list-post ' . $id;
				}

				$rules = array(
					$id => array(
						array(	'prop' => 'background-color',
								'key' => 'background_color'
						),
						array(	'prop' => 'background-image',
								'key' => 'background_image'
						),
						array(	'prop' => 'background-repeat',
								'key' => 'background_repeat'
						),
						array(	'prop' => 'background-position',
								'key' => array('background_position_x', 'background_position_y')
						)
					),
					"$pid h3, $pid h3 a, $pid .product_title, $pid .product_title a, $pid .woocommerce-breadcrumb a, $pid .star-rating" => array(
						array(	'prop' => 'color',
								'key' => 'title_font_color'
						)
					),
					"$id .summary .price" => array(
						array(	'prop' => 'color',
								'key' => 'price_font_color'
						)
					),
					"$pid" => array(
						array(	'prop' => 'color',
								'key' => 'description_font_color'
						)
					),
					"$id .product-description a, $id .product_meta a, $id .quantity .plus, $id .quantity .minus" => array(
						array(	'prop' => 'color',
								'key' => 'link_font_color'
						)
					),
					"$pid .button.outline" => array(
						array(	'prop' => 'color',
								'key' => 'link_font_color',
								'important' => true
						),
						array(	'prop' => 'border-color',
								'key' => 'link_font_color'
						)
					),
					"$pid .single_add_to_cart_button, $pid .theme_add_to_cart_button, $pid .added_to_cart.button, $pid .quantity input.qty, $product_id .variations select" => array(
						array(	'prop' => 'color',
								'key' => 'button_font_color'
						),
						array(	'prop' => 'background-color',
								'key' => 'button_background_color'
						),
						array(	'prop' => 'border-color',
								'key' => 'button_background_color'
						),
					),
				);
				break;
			case 'slider':
				$id = '.slider-post.post-' . $post_id;
				$rules = array(
					$id => array(
						array(	'prop' => 'background-color',
								'key' => 'background_color'
						)
					),
					"$id .slide-post-title, $id .slide-post-title a" => array(
						array(	'prop' => 'color',
								'key' => 'title_font_color'
						),
						array(	'prop' => 'font-size',
								'key' => array('title_font_size', 'title_font_size_unit')
						),
						array(	'prop' => 'font-family',
								'key' => 'title_font_family'
						),
					),
					"$id .slide-excerpt" => array(
						array(	'prop' => 'color',
								'key' => 'text_font_color'
						)
					),
					"$id a" => array(
						array(	'prop' => 'color',
								'key' => 'link_font_color'
						)
					),
				);
				break;
			case 'page':
				$id = '.page-id-' . $post_id;

				if( $header_type !== 'transparent' ) {
					$rules[ $id . ' #headerwrap' ] = array(
						array(
							'prop' => 'background-color',
							'key' => 'background_color'
						),
						array(
							'prop' => 'background-image',
							'key' => 'background_image'
						),
						array(
							'prop' => 'background-repeat',
							'key' => 'background_repeat'
						),
						array(
							'prop' => 'background-position',
							'key' => array( 'background_position_x', 'background_position_y' )
						)
					);
				}

				$rules[ $id . implode( ', ' . $id, array( ' #headerwrap', ' #headerwrap .widget', ' #site-logo', ' #site-description' ) ) ] = array(
					array(
						'prop' => 'color',
						'key'  => 'headerwrap_text_color'
					),
				);

				$rules[ $id . ' #headerwrap a, ' . $id . ' #main-nav > li:hover > a:before' ] = array(
					array(
						'prop' => 'color',
						'key'  => 'headerwrap_link_color'
					),
				);

			break;
		}
		foreach ( $rules as $selector => $property ) {
			foreach ( $property as $val ) {
				$prop = $val['prop'];
				$key = $val['key'];
				if ( is_array( $key ) ) {
					if ( 'fullcover' == themify_get( $key[0] ) ) {
						continue;
					}
					if ( $prop == 'font-size' && themify_check( $key[0] ) ){
						$css[$selector][$prop] = $prop .': '. themify_get( $key[0] ) . themify_get($key[1]);
					}
					if ( $prop == 'background-position' && themify_check( $key[0] ) ) {
						$css[$selector][$prop] = $prop .': '. themify_get($key[0]) . ' ' . themify_get($key[1]);
					}
				} elseif ( themify_check( $key ) && 'default' != themify_get( $key ) ) {
					if ( 'fullcover' == themify_get( $key ) ) {
						continue;
					}
					if ( $prop == 'color' || stripos($prop, 'color')) {
						$css[$selector][$prop] = $prop .': '.themify_get_color( $key );
					}
					elseif ( $prop == 'background-image' ) {
						$css[$selector][$prop] = $prop .': url('.themify_get($key).')';
					}
					elseif ( $prop == 'font-family' ) {
						$font = themify_get( $key );
						$css[$selector][$prop] = $prop .': '. $font;
						if ( ! in_array( $font, themify_get_web_safe_font_list( true ) ) ) {
							$themify->google_fonts .= str_replace(' ', '+', $font.'|');
						}
					}
					else {
						$css[$selector][$prop] = $prop .': '. themify_get( $key );
					}
				}
				if ( isset( $val['important'] ) && $val['important'] && isset( $css[$selector] ) && isset( $css[$selector][$prop] ) ) {
					$css[$selector][$prop] .= ' !important';
				}
			}
			if ( ! empty( $css[$selector] ) ) {
				$style .= "$selector {\n\t" . implode( ";\n\t", $css[$selector] ) . "\n}\n";
			}
		}

		if ( '' != $style ) {
			echo "\n<!-- $post_type-$post_id Style -->\n<style>\n$style</style>\n<!-- End $post_type-$post_id Style -->\n";
		}
	}
}
add_action( 'wp_head', 'themify_theme_custom_post_css', 77 );

/**
 * Outputs classes based on certain user-specified parameters.
 *
 * @since 1.0.0
 */
function themify_theme_query_classes() {
	global $themify, $wp_query;
	$class = array();
	$is_product_query_page = themify_theme_is_product_query();

	if( ! empty( $themify->builder_args['content_layout'] ) ) {
		$class[] = $themify->builder_args['content_layout'];
	} else if( ! empty( $themify->post_layout_type ) ) {
		$class[] = $themify->post_layout_type;
	}

	if( ! isset( $themify->builder_args['is_product'] ) || $is_product_query_page ) {
		$class[] = $themify->layout;
		
		if ( isset( $themify->query_post_type ) && ! in_array( $themify->query_post_type, array( 'post', 'page','portfolio') ) ) {
			$class[] = $themify->query_post_type;
		}

		$queried_object = get_queried_object();
		$post_type = $wp_query->get( 'post_type' );
		$is_product_query = themify_is_product_search()
			|| ( is_object( $queried_object )
				? ( is_array( $queried_object->name )
					? in_array( 'product', $queried_object->name )
					: $queried_object->name === 'product' )
				: false )
			|| ( !empty( $post_type )
				&& is_array( $post_type )
					? in_array( 'product', $post_type )
					: $post_type === 'product' );

		if (themify_is_query_page() || is_archive() || is_search() || is_tax() || is_home() || $is_product_query || $is_product_query_page){
			if( $is_product_query || is_tax('product_cat') ) {
				if( $themify->post_layout != 'auto_tiles' ){
					$themify->post_layout = themify_get( 'setting-products_layout' );
				}
			}
			
			$is_masonry = !in_array($themify->post_layout,array('auto_tiles','list-post','list-large-image','list-thumb-image'));

			if($is_product_query_page || $is_product_query || get_post_type()==='product' ||  (isset( $themify->query_post_type ) && $themify->query_post_type==='product')){
				if('no-gutter' == themify_theme_get( 'gutter','','setting-product_post_gutter' )){
					$class[] = 'no-gutter';
				}
				if($is_masonry){
					if($is_product_query_page){
						$masonry = themify_theme_get('masonry');
						$masonry = $masonry==='yes'?true:($masonry==='no'?false:null);
					}
					if(! isset($masonry)){
						$masonry = !themify_check('setting-shop_masonry_disabled');
					}
				}
				if($themify->post_layout!=='auto_tiles' && $themify->post_layout!=='list-large-image' && ($temp_class = themify_theme_get( 'content_layout' ) )){
					$class[] = $temp_class;
				}
			}
			else {
				if($is_masonry){
					$masonry = 'yes' == themify_theme_get( 'post_masonry' );
				}
				if($themify->post_layout!=='auto_tiles'  && $themify->post_layout!=='list-large-image' && ($temp_class = themify_theme_get( 'post_content_layout' ) )){
					$class[] = $temp_class;
				}
				if('no-gutter' == themify_theme_get( 'post_gutter','','setting-post_gutter' )){
					$class[] = 'no-gutter';
				}
			}
			if($is_masonry && $masonry){
				$class[] = 'masonry';
			}
			if ( $temp_class = themify_theme_get( 'more_posts', 'infinite' ) ) {
				$class[] = $temp_class;
			}
			
		}
	}
	$class[] = $themify->post_layout;

	return implode( ' ', apply_filters( 'themify_theme_loops_wrapper_class', $class ) );
}

//Change comments fields position
add_filter('comment_form_fields', 'themify_reorder_comment_fields' );
function themify_reorder_comment_fields($fields ){
    $new_fields = array();
    $order = array('author','email','url','comment');
    foreach( $order as $key ){
        if(isset($fields[$key])){
            $new_fields[ $key ] = $fields[ $key ];
            unset( $fields[ $key ] );
        }
    }
    if( $fields ){
        foreach( $fields as $key => $val ){
                $new_fields[ $key ] = $val;
        }
    }
    return $new_fields;
}


/*************************************************************
 * Product Lightbox
 *************************************************************/

/**
 * Template redirect function
 **/
function themify_do_theme_redirect( $url ) {
	global $post, $wp_query;

	if ( have_posts() ) {
		include( $url );
		die();
	} else {
		$wp_query->is_404 = true;
	}
}




/**
 * Register any extra string for translation with external plugin
 * @param $strings
 * @return array
 */
function themify_theme_register_strings( $strings ) {
	$strings[] = 'setting-store_info_address';
	return $strings;
}
add_filter( 'themify_wpml_registered_strings', 'themify_theme_register_strings' );

if( ! function_exists( 'themify_theme_is_mobile' ) ) :
	function themify_theme_is_mobile() {
        if ( function_exists( 'themify_is_touch' ) ) {
            $isPhone = themify_is_touch( 'phone' );
        } else {
            if ( ! class_exists( 'Themify_Mobile_Detect' ) ) {
                require_once THEMIFY_DIR . '/class-themify-mobile-detect.php';
            }
            $detect = new Themify_Mobile_Detect;
            $isPhone = $detect->isMobile() && !$detect->isTablet();
        }
        return $isPhone;
	}
endif;

/**
 * List of layouts supported by the theme to display WooCommerce products
 *
 * @return array
 * @since 1.0.0
 */
function themify_theme_woocommerce_post_layouts( $arr ) {
	return array( 'list-post', 'grid2', 'grid3', 'grid4','auto_tiles' );
}
add_filter( 'builder_woocommerce_theme_layouts', 'themify_theme_woocommerce_post_layouts' );

/**
 * Announcement Bar compatibility
 *
 * @since 1.0.0
 */
function themify_theme_announcement_bar_script_vars( $vars ) {
	$vars['margin_top_to_bar_height'] = '#headerwrap';
	
	return $vars;
}
add_filter( 'announcement_bar_script_vars', 'themify_theme_announcement_bar_script_vars' );

/**
 * Icon menu Navigation
 *
 * @since 1.0.0
 */
function themify_menu_icon( $title, $id = '' ) {
	if ( $id && ( $icon = Themify_Menu_Icons::get_instance()->get_menu_icon( $id ) ) ) {
		$title = '<span class="tooltip">' . $title . '</span>';
	}

	return $title;
}

function themify_remove_menu_icon( $nav_menu ) {
	remove_filter( 'the_title', 'themify_menu_icon', 9, 2 );
	return $nav_menu;
}

function themify_filter_nav_icons( $args ) {
	if( $args['theme_location'] === 'icon-menu' ) {
		add_filter( 'the_title', 'themify_menu_icon', 9, 2 );
		add_filter( 'wp_nav_menu', 'themify_remove_menu_icon', 10, 1 );
	}
	
	return $args;
}
add_filter( 'wp_nav_menu_args', 'themify_filter_nav_icons', 9, 1 );

/**
 * Search Autocomplete
 *
 * @since 1.0.0
 */
 
function themify_search_autocomplete(){
	if(!empty($_POST['term'])){
		$term  = sanitize_text_field($_POST['term']);
		if(!empty($term)){
			$query_args = array(
						'post_type'=>array('post'),
						'post_status'=>'publish',
						'posts_per_page'=>22,
						's'=>$term
			);
			global $wpdb,$query,$is_woocmerce_active,$is_product;
			$is_woocmerce_active = themify_is_woocommerce_active();
			if($is_woocmerce_active){
				$query_args['post_type'][] = 'product';
			}
			
			$query_args = apply_filters('themify_search_args',$query_args);
			wp_reset_postdata();
			$query = new WP_Query( $query_args );
			
			if($is_woocmerce_active){
				$is_woocmerce_active = false;
				$is_product = false;
				while ( $query->have_posts() ){
					$query->the_post();
					if(get_post_type()==='product'){
						$is_woocmerce_active = true;
					}
					else{
						$is_product = true;
					}
					
					if($is_product && $is_woocmerce_active){
						break;
					}
				}
				$query->rewind_posts();
			}
			else{
				$is_product = true;
			}
			get_template_part( 'includes/search-box-result' );
		}
	}
	wp_die();
}



add_action('wp_ajax_themify_search_autocomplete','themify_search_autocomplete');
add_action('wp_ajax_nopriv_themify_search_autocomplete','themify_search_autocomplete');

if (!function_exists('themify_set_tiles_template')) {

    /**
     * Set template for auto tiled
     * @return array
     */
    function themify_set_tiles_template() {
        //Each elements must have unique char and length = 4. Otherwise the result can be unexpected. For example: can't be 1=>'AAAA' and 2=>'ABAB'
        // Reserved chars 'X', 'Y', 'Z', 'V', 'T', 'F', 'K' used in JS
        $knows_grids = array(1 => array("AAAA"),
            2 => array('BBCC', 'BBCC'),
            3 => array('DD..'),
            4 => array('.EEF', '.EEF')
        );
        if (!isset($knows_grids[5])) {
            $knows_grids[5] = $knows_grids[3];
            foreach ($knows_grids[2] as $v) {
                $knows_grids[5][] = $v;
            }
        }
        if (!isset($knows_grids[6])) {
            $knows_grids[6] = $knows_grids[4];
            foreach ($knows_grids[2] as $v) {
                $knows_grids[6][] = $v;
            }
        }
        if (!isset($knows_grids[7])) {
            $knows_grids[7] = $knows_grids[4];
            foreach ($knows_grids[3] as $v) {
                $knows_grids[7][] = $v;
            }
        }
        if (!isset($knows_grids[8])) {
            $knows_grids[8] = $knows_grids[7];
            foreach ($knows_grids[1] as $v) {
                $knows_grids[8][] = $v;
            }
        }
        if (!isset($knows_grids[9])) {
            $knows_grids[9] = $knows_grids[7];
            foreach ($knows_grids[2] as $v) {
                $knows_grids[9][] = $v;
            }
        }
        if (!isset($knows_grids[10])) {
            $knows_grids[10] = $knows_grids[7];
            $knows_grids[10][] = 'MMNN';
            $knows_grids[10][] = 'MMPP';
        }
        if (!isset($knows_grids[11])) {
            $knows_grids[11] = $knows_grids[10];
            foreach ($knows_grids[1] as $v) {
                $knows_grids[11][] = $v;
            }
        }
        if (!isset($knows_grids[12])) {
            $knows_grids[12] = $knows_grids[10];
            foreach ($knows_grids[2] as $v) {
                $knows_grids[12][] = $v;
            }
        }
        if (!isset($knows_grids[13])) {
            $knows_grids[13] = $knows_grids[10];
            $knows_grids[13][] = 'LSRR';
            $knows_grids[13][] = 'LSRR';
        }

        return apply_filters('themify_tiledata_template', $knows_grids);
    }

}

//product archive slider 

function themify_get_product_slider($product){
	static $slider_active = null;
	global $themify;
	if(is_null($slider_active)){
		$slider_active = themify_theme_get('slider_hover','','setting-products_slider')!=='disable';
	}
	$is_slider_active = isset($themify->builder_args['slider_hover'])?$themify->builder_args['slider_hover']==='slider_hover':$slider_active;
	$images = array();
	if($is_slider_active){
		$images = themify_get_gallery($product);
		if(!empty($images)){
			$main = $product->get_image_id();
			if($main){
				$images[] = $main;
			}
			$images = implode(',',$images);
		}
	}
	return $images;
}

function themify_get_gallery($product) {
	if( ! empty( $product ) ) {
		if(version_compare(WOOCOMMERCE_VERSION,'3.0.0','>=' )){
			return  $product->get_gallery_image_ids();
		}
		else{
			return $product->get_gallery_image_ids();
		}
	}
}

function themify_product_slider(){
	if(!empty($_POST['slider'])){
		$attachment_ids = explode(',',$_POST['slider']);
		$result = array();
		$is_disabled = themify_is_image_script_disabled();
		$width = $height = '';
		if(!$is_disabled){
			if(empty($_POST['width']) && empty($_POST['height'])){
				$width = themify_get( 'setting-default_product_index_image_post_width' );
				$height = themify_get( 'setting-default_product_index_image_post_height' );
			}
			else{
				if(is_numeric($_POST['width'])){
					$width = intval($_POST['width']);
				}
				if(is_numeric($_POST['height'])){
					$height = intval($_POST['height']);
				}
			}
		}
		foreach ( $attachment_ids as $attachment_id ) {
			if($is_disabled || (!$width && !$height)){
				$img = wp_get_attachment_image_url( $attachment_id,'shop_catalog');
			}
			else{
				$src = wp_get_attachment_image_url( $attachment_id);
				if(!$src){
					continue;
				}
				$img = themify_get_image('ignore=true&urlonly=1&image_size=shop_catalog&w='.$width.'&h='.$height.'&src='.$src);
				if(!$img){
					$img = wp_get_attachment_image_url( $attachment_id,'shop_catalog');
				}
			}
			if ( $img ) {
				$result['big'][] = $img;
				$thumbs = !$is_disabled?themify_get_image('ignore=true&urlonly=1&image_size=shop_thumbnail&w=28&h=28&src='.$src):false;
				$result['thumbs'][] = $thumbs?$thumbs:wp_get_attachment_image_url( $attachment_id,'shop_thumbnail');
			}
		}
		echo wp_json_encode($result);
	}
	wp_die();
}
add_action('wp_ajax_themify_product_slider','themify_product_slider');
add_action('wp_ajax_nopriv_themify_product_slider','themify_product_slider');

//Add tiled in WooCommerce Layout
function themify_add_tile_layout($options,$module){
	if($module->slug==='products' || $module->slug==='post'){
		$is_product = $module->slug==='products';
		$auto_tiles = array('value' => 'auto_tiles', 'img' => THEME_URI.'/images/layout-icons/auto-tiles.png', 'label' => __('Auto Tiles', 'themify'));
		$index = false;
		foreach($options as $k=>$opt){
			
			if($is_product){
				if($opt['id']==='list'){
					$options[$k]['fields'][0]['options'][] = $auto_tiles;
					$index = $k+1;
					break;
				}
			}
			elseif($opt['id']==='layout_post'){
				$options[$k]['options'][] = $auto_tiles;
				$index = $k+2;
				break;
			}
		}
			$append = array(
				array(
					'id' => 'content_layout',
					'type' => 'select',
					'label' => __('Content Layout', 'themify'),
					'options' => array(
						'default' => __('Default', 'themify'),
						'no' => __('No', 'themify'),
						'overlay' => __('Overlay', 'themify'),
						'polaroid' => __('Polaroid', 'themify'),
						'boxed' => __('Boxed', 'themify'),
						'flip' => __('Flip', 'themify')
					)
				),
				array(
					'id' => 'masonry_post',
					'type' => 'select',
					'label' => __('Masonry Layout', 'themify'),
					'options' => array(
						'default' => __('Default', 'themify'),
						'yes' => __('Yes', 'themify'),
						'no' => __('No', 'themify')
					)
				),
				array(
					'id' => 'post_gutter',
					'type' => 'select',
					'label' => __('Post Gutter ', 'themify'),
					'options' => array(
						'default' => __('Default', 'themify'),
						'yes' => __('Yes', 'themify'),
						'no' => __('No', 'themify')
					)
				)
			);
			
			if($is_product){
				$append[] = array(
                                        'id' => 'disable_product_slider',
                                        'type' => 'select',
                                        'label' => __('Product Hover Gallery', 'themify'),
                                        'options' => array(
                                                'default' => __('Default', 'themify'),
                                                'enable' => __('Enable', 'themify'),
                                                'disable' => __('Disable', 'themify')
                                        )
                                );
				
			}
			array_splice($options,$index,0,$append);
	}
	elseif($module->slug==='fancy-heading'){
			$append = array(array(
							'id' => 'inline_text',
							'type' => 'checkbox',
							'label' => __('Inline Text', 'themify'),
							'options' => array(
								array( 'name' => '1', 'value' => __( 'Display main & sub heading as one line', 'themify' )),
							)
					));
			foreach($options as $k=>$opt){
				if($opt['id']==='text_alignment'){
					$index = $k+1;
					break;
				}
			}
			array_splice($options,$index,0,$append);
	}
	return $options;
}

add_filter('themify_builder_module_settings_fields','themify_add_tile_layout',10,2);

//Masonry for WC Builder Addon and Post Module
function themify_builder_args( $show, $mod, $builder_id, $identifier ) {
	global $themify;
	$themify->builder_args = array();
	
	if( isset( $mod['mod_name'] ) && isset( $mod['mod_settings'] ) ) {
		$mod_name = $mod['mod_name'];
		$mod_settings = $mod['mod_settings'];

		if( in_array( $mod_name, array( 'products', 'post' ) ) ) {
			$is_product = $mod_name === 'products';
			$layout = isset( $mod_settings['layout_' . $mod_name] )
				? $mod_settings['layout_' . $mod_name] : 'grid3';

			$masonary = in_array( $layout, array('grid2', 'grid3', 'grid4') )
				&& ! empty( $mod_settings['masonry_post'] )
					? $mod_settings['masonry_post'] : '';

			$content_layout = $layout != 'auto_tiles'
				&& ! empty( $mod_settings['content_layout'] )
					? $mod_settings['content_layout'] : '';

			$post_gutter = ! empty( $mod_settings['post_gutter'] )
				? $mod_settings['post_gutter'] : '';
			
			if( $is_product ) {
				$masonary === 'default' && ( $masonary = themify_get( 'setting-post_masonry' ) );
				$masonary = $masonary === 'yes';

				$content_layout = $content_layout === 'default'
					? themify_get( 'setting-product_content_layout' )
					: $content_layout !== 'no' ? $content_layout : '';

				$post_gutter = $post_gutter === 'default'
					? themify_get( 'setting-post_gutter' ) === 'no-gutter'
					: $post_gutter === 'no';

				$product_hover = ! empty( $mod_settings['disable_product_slider'] )
					? $mod_settings['disable_product_slider'] : '';

				$product_hover === 'default' && ( $product_hover = themify_get( 'setting-products_slider' ) );
				$product_hover = $product_hover === 'enable' ? 'slider_hover' : 'slider_no_hover';

				$themify->builder_args['slider_hover'] = $product_hover;
				$themify->builder_args['is_product'] = true;
			} else {
				$masonary = $masonary === 'default'
					? ! themify_check( 'setting-shop_masonry_disabled' ) : $masonary === 'yes';

				$content_layout = $content_layout === 'default'
					? themify_get( 'setting-post_content_layout' ) 
					: $content_layout !== 'no' ? $content_layout : '';

				$post_gutter = $post_gutter === 'default'
					? themify_get( 'setting-product_post_gutter' ) === 'no-gutter'
					: $post_gutter === 'no';
			}
			
			$masonary && ( $themify->builder_args['masonry'] = 'masonry' );
			$content_layout && ( $themify->builder_args['content_layout'] = $content_layout );
			$post_gutter && ( $themify->builder_args['gutter'] = 'no-gutter' );

			$filter_name = $is_product 
				? 'themify_theme_loops_wrapper_class'
				: ! empty( $themify->builder_args ) ? 'themify_builder_module_loops_wrapper' : '';

			$filter_name && add_filter( $filter_name , 'themify_add_builder_classes', 10, 1);
		} elseif( $mod_name === 'fancy-heading' && isset( $mod_settings['inline_text'] )
			&& $mod_settings['inline_text'] == 1 ) {
			add_filter( 'themify_builder_module_container_props', 'themify_add_fancy_heading_class', 10, 4 );
		}
	}

	return $show;
}
add_filter('themify_builder_module_display', 'themify_builder_args', 10, 4);

function themify_builder_reset_global_args() {
	global $themify;

	if( ! empty( $themify->builder_args['content_layout'] ) ) {
		unset( $themify->builder_args['content_layout'] );
	}
}
add_action( 'themify_builder_after_template_content_render', 'themify_builder_reset_global_args' );
add_action( 'themify_builder_row_end', 'themify_builder_reset_global_args' );

function themify_add_builder_classes($classes) {
    global $themify;
    remove_filter('themify_theme_loops_wrapper_class', 'themify_add_builder_classes', 10, 1);
    remove_filter('themify_builder_module_loops_wrapper', 'themify_add_builder_classes', 10, 1);
	$args = $themify->builder_args;
	unset($args['is_product']);
    $args = implode(' ', $args);
    if (is_array($classes)) {
        $classes[] = $args;
    } else {
        $classes.=' ' . $args;
    }
    return $classes;
}

function themify_add_fancy_heading_class($container,$args,$mod_name, $module_ID ){
	remove_filter('themify_builder_module_container_props','themify_add_fancy_heading_class',10,4);
	$container['class'].= ' inline-fancy-heading';
	return $container;
}

if (!empty($_GET['type']) && in_array($_GET['type'], array('post', 'product')) && !is_admin()) {
    add_filter('pre_get_posts', 'themify_search_pre_get_posts', 5, 1);
}

function themify_search_pre_get_posts($query) {
    if ($query->is_main_query() && $query->is_search()) {
        $post_type = $_GET['type'];
        $post_types = $post_type === 'post' ? array('post', 'page') : (themify_is_woocommerce_active() ? $post_type : false);
        if ($post_types) {
            if ($post_type === 'post' && ((is_array($query->post_type) && !in_array('page', $query->post_type)) || (themify_get('setting-search_settings_exclude')))) {
                $post_types = $post_type;
            }
            global $wp_post_types;
            $searchable_cpt = is_array($post_types) ? $post_types : array($post_types);
            //for builder's action do_search
            foreach ($wp_post_types as $k => &$p) {
                $p->exclude_from_search = !in_array($k, $searchable_cpt);
            }
            $query->set('post_type', $post_types);
        }
    }
    return $query;
}

//Social Banners

function themify_get_footer_banners() {

    $socials = array(
        'twitter' => __('Twitter', 'themify'),
        'facebook' => __('Facebook', 'themify'),
        'pinterest' => __('Pinterest', 'themify'),
        'youtube' => __('Youtube', 'themify'),
        'linkedin' => __('Linkedin', 'themify'),
        'google' => __('Google+', 'themify'),
        'instagram' => __('Instagram', 'themify')
    );
    return apply_filters('themify_footer_banners', $socials);
}

function themify_is_product_search(){
	static $is_product_search = null;
	if(is_null($is_product_search)){
		$is_product_search = isset($_GET['type']) && $_GET['type']==='product' && themify_is_woocommerce_active();
	}
	return $is_product_search;
}


////////////////////////////////////
// Custom Skin
////////////////////////////////////
add_filter( 'themify_show_skins_and_demos_admin', '__return_true' );

/**
* Customize the skins list in the admin screen
*
* @since 1.0.0
*/
function themify_theme_skins_list( $skins ) {
	unset( $skins[0] ); // remove No Skin option

	// set Default as the first choice
	$default = $skins['default'];
	unset( $skins['default'] );

	return array_merge( array( 'default' => $default ), $skins );
}
add_filter( 'themify_theme_skins', 'themify_theme_skins_list' ); 

/**
 * Allow updating bonus addons for Shoppe
 *
 * @since 1.0.2
 */
function themify_theme_bonus_addons_update( $match, $subs ) {
	$theme = wp_get_theme();
	$theme_name = ( is_child_theme() ) ? $theme->parent()->Name : $theme->display('Name');
	$theme_name = preg_replace( '/^Themify\s/', '', $theme_name );
	foreach ( $subs as $key => $value ) {
		if ( ( stripos( $value['title'], $theme_name ) !== false || stripos( $value['title'], 'Standard Club' ) !== false ) && isset( $_POST['nicename_short'] ) && in_array( $_POST['nicename_short'], array( 'Slider Pro', 'Pricing Table', 'Maps Pro', 'Typewriter', 'Image Pro', 'Timeline', 'WooCommmerce', 'Contact', 'Counter', 'Progress Bar', 'Countdown', 'Audio' ) ) ) {
			$match = 'true';
			break;
		}
	}

	return $match;
}
add_filter( 'themify_builder_validate_login', 'themify_theme_bonus_addons_update', 10, 2 );

function themify_theme_sticky_logo(){
     if(themify_theme_fixed_header()){
        global $themify_customizer;
        $logo = json_decode($themify_customizer->get_cached_mod('sticky_header_imageselect'));
        return isset($logo->src) && '' != $logo->src?$logo:false;
     }
     else{
         return false;
     }
}

/**
 * Themibox helper, is default gallery
 */
if( ! function_exists( 'localize_variation_product' ) ):
function localize_variation_product( $args ) {
	if( themify_is_woocommerce_active() ) {
		$args[ 'is_default_gallery' ] = themify_get_gallery_type() === 'default';
	}

	return $args;
}
endif;
add_filter( 'themify_shop_js_vars', 'localize_variation_product' );

if ( ! function_exists( 'themify_allow_menu_highlight' ) ) {
	/**
	 * Enable menu link highlight.
	 *
	 * @since 1.2.6
	 *
	 * @param boolean $allow.
	 *
	 * @return boolean.
	 */
	function themify_allow_menu_highlight( $allow ) {
		return true;
	}
	add_filter( 'themify_menu_highlight_link', 'themify_allow_menu_highlight', 10 );
}